function _classPrivateFieldLooseBase(e, t) { if (!{}.hasOwnProperty.call(e, t)) throw new TypeError("attempted to use private field on non-instance"); return e; }
var id = 0;
function _classPrivateFieldLooseKey(e) { return "__private_" + id++ + "_" + e; }
import { BasePlugin } from '@uppy/core';
import EventManager from '@uppy/core/lib/EventManager.js';
import { RateLimitedQueue, internalRateLimitedQueue
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore untyped
} from '@uppy/utils/lib/RateLimitedQueue';
import NetworkError from '@uppy/utils/lib/NetworkError';
import isNetworkError from '@uppy/utils/lib/isNetworkError';
import { fetcher } from '@uppy/utils/lib/fetcher';
import { filterNonFailedFiles, filterFilesToEmitUploadStarted } from '@uppy/utils/lib/fileFilters';
import getAllowedMetaFields from '@uppy/utils/lib/getAllowedMetaFields';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore We don't want TS to generate types for the package.json
const packageJson = {
  "version": "4.3.3"
};
import locale from './locale.js';
function buildResponseError(xhr, err) {
  let error = err;
  // No error message
  if (!error) error = new Error('Upload error');
  // Got an error message string
  if (typeof error === 'string') error = new Error(error);
  // Got something else
  if (!(error instanceof Error)) {
    error = Object.assign(new Error('Upload error'), {
      data: error
    });
  }
  if (isNetworkError(xhr)) {
    error = new NetworkError(error, xhr);
    return error;
  }

  // @ts-expect-error request can only be set on NetworkError
  // but we use NetworkError to distinguish between errors.
  error.request = xhr;
  return error;
}

/**
 * Set `data.type` in the blob to `file.meta.type`,
 * because we might have detected a more accurate file type in Uppy
 * https://stackoverflow.com/a/50875615
 */
function setTypeInBlob(file) {
  const dataWithUpdatedType = file.data.slice(0, file.data.size, file.meta.type);
  return dataWithUpdatedType;
}
const defaultOptions = {
  formData: true,
  fieldName: 'file',
  method: 'post',
  allowedMetaFields: true,
  bundle: false,
  headers: {},
  timeout: 30 * 1000,
  limit: 5,
  withCredentials: false,
  responseType: ''
};
var _getFetcher = /*#__PURE__*/_classPrivateFieldLooseKey("getFetcher");
var _uploadLocalFile = /*#__PURE__*/_classPrivateFieldLooseKey("uploadLocalFile");
var _uploadBundle = /*#__PURE__*/_classPrivateFieldLooseKey("uploadBundle");
var _getCompanionClientArgs = /*#__PURE__*/_classPrivateFieldLooseKey("getCompanionClientArgs");
var _uploadFiles = /*#__PURE__*/_classPrivateFieldLooseKey("uploadFiles");
var _handleUpload = /*#__PURE__*/_classPrivateFieldLooseKey("handleUpload");
export default class XHRUpload extends BasePlugin {
  constructor(uppy, _opts) {
    super(uppy, {
      ...defaultOptions,
      fieldName: _opts.bundle ? 'files[]' : 'file',
      ..._opts
    });
    Object.defineProperty(this, _uploadFiles, {
      value: _uploadFiles2
    });
    Object.defineProperty(this, _getCompanionClientArgs, {
      value: _getCompanionClientArgs2
    });
    Object.defineProperty(this, _uploadBundle, {
      value: _uploadBundle2
    });
    Object.defineProperty(this, _uploadLocalFile, {
      value: _uploadLocalFile2
    });
    Object.defineProperty(this, _getFetcher, {
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, _handleUpload, {
      writable: true,
      value: async fileIDs => {
        if (fileIDs.length === 0) {
          this.uppy.log('[XHRUpload] No files to upload!');
          return;
        }

        // No limit configured by the user, and no RateLimitedQueue passed in by a "parent" plugin
        // (basically just AwsS3) using the internal symbol
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore untyped internal
        if (this.opts.limit === 0 && !this.opts[internalRateLimitedQueue]) {
          this.uppy.log('[XHRUpload] When uploading multiple files at once, consider setting the `limit` option (to `10` for example), to limit the number of concurrent uploads, which helps prevent memory and network issues: https://uppy.io/docs/xhr-upload/#limit-0', 'warning');
        }
        this.uppy.log('[XHRUpload] Uploading...');
        const files = this.uppy.getFilesByIds(fileIDs);
        const filesFiltered = filterNonFailedFiles(files);
        const filesToEmit = filterFilesToEmitUploadStarted(filesFiltered);
        this.uppy.emit('upload-start', filesToEmit);
        if (this.opts.bundle) {
          // if bundle: true, we don’t support remote uploads
          const isSomeFileRemote = filesFiltered.some(file => file.isRemote);
          if (isSomeFileRemote) {
            throw new Error('Can’t upload remote files when the `bundle: true` option is set');
          }
          if (typeof this.opts.headers === 'function') {
            throw new TypeError('`headers` may not be a function when the `bundle: true` option is set');
          }
          await _classPrivateFieldLooseBase(this, _uploadBundle)[_uploadBundle](filesFiltered);
        } else {
          await _classPrivateFieldLooseBase(this, _uploadFiles)[_uploadFiles](filesFiltered);
        }
      }
    });
    this.type = 'uploader';
    this.id = this.opts.id || 'XHRUpload';
    this.defaultLocale = locale;
    this.i18nInit();

    // Simultaneous upload limiting is shared across all uploads with this plugin.
    if (internalRateLimitedQueue in this.opts) {
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore untyped internal
      this.requests = this.opts[internalRateLimitedQueue];
    } else {
      this.requests = new RateLimitedQueue(this.opts.limit);
    }
    if (this.opts.bundle && !this.opts.formData) {
      throw new Error('`opts.formData` must be true when `opts.bundle` is enabled.');
    }
    if (this.opts.bundle && typeof this.opts.headers === 'function') {
      throw new Error('`opts.headers` can not be a function when the `bundle: true` option is set.');
    }
    if ((_opts == null ? void 0 : _opts.allowedMetaFields) === undefined && 'metaFields' in this.opts) {
      throw new Error('The `metaFields` option has been renamed to `allowedMetaFields`.');
    }
    this.uploaderEvents = Object.create(null);
    /**
     * xhr-upload wrapper for `fetcher` to handle user options
     * `validateStatus`, `getResponseError`, `getResponseData`
     * and to emit `upload-progress`, `upload-error`, and `upload-success` events.
     */
    _classPrivateFieldLooseBase(this, _getFetcher)[_getFetcher] = files => {
      return async (url, options) => {
        try {
          var _this$opts$getRespons, _this$opts2, _body3;
          const res = await fetcher(url, {
            ...options,
            onBeforeRequest: (xhr, retryCount) => {
              var _this$opts$onBeforeRe, _this$opts;
              return (_this$opts$onBeforeRe = (_this$opts = this.opts).onBeforeRequest) == null ? void 0 : _this$opts$onBeforeRe.call(_this$opts, xhr, retryCount, files);
            },
            shouldRetry: this.opts.shouldRetry,
            onAfterResponse: this.opts.onAfterResponse,
            onTimeout: timeout => {
              const seconds = Math.ceil(timeout / 1000);
              const error = new Error(this.i18n('uploadStalled', {
                seconds
              }));
              this.uppy.emit('upload-stalled', error, files);
            },
            onUploadProgress: event => {
              if (event.lengthComputable) {
                for (const {
                  id
                } of files) {
                  var _file$progress$upload;
                  const file = this.uppy.getFile(id);
                  this.uppy.emit('upload-progress', file, {
                    uploadStarted: (_file$progress$upload = file.progress.uploadStarted) != null ? _file$progress$upload : 0,
                    bytesUploaded: event.loaded / event.total * file.size,
                    bytesTotal: file.size
                  });
                }
              }
            }
          });
          let body = await ((_this$opts$getRespons = (_this$opts2 = this.opts).getResponseData) == null ? void 0 : _this$opts$getRespons.call(_this$opts2, res));
          if (res.responseType === 'json') {
            var _body;
            (_body = body) != null ? _body : body = res.response;
          } else {
            try {
              var _body2;
              (_body2 = body) != null ? _body2 : body = JSON.parse(res.responseText);
            } catch (cause) {
              throw new Error('@uppy/xhr-upload expects a JSON response (with a `url` property). To parse non-JSON responses, use `getResponseData` to turn your response into JSON.', {
                cause
              });
            }
          }
          const uploadURL = typeof ((_body3 = body) == null ? void 0 : _body3.url) === 'string' ? body.url : undefined;
          for (const {
            id
          } of files) {
            this.uppy.emit('upload-success', this.uppy.getFile(id), {
              status: res.status,
              body,
              uploadURL
            });
          }
          return res;
        } catch (error) {
          if (error.name === 'AbortError') {
            return undefined;
          }
          const request = error.request;
          for (const file of files) {
            this.uppy.emit('upload-error', this.uppy.getFile(file.id), buildResponseError(request, error), request);
          }
          throw error;
        }
      };
    };
  }
  getOptions(file) {
    const overrides = this.uppy.getState().xhrUpload;
    const {
      headers
    } = this.opts;
    const opts = {
      ...this.opts,
      ...(overrides || {}),
      ...(file.xhrUpload || {}),
      headers: {}
    };
    // Support for `headers` as a function, only in the XHRUpload settings.
    // Options set by other plugins in Uppy state or on the files themselves are still merged in afterward.
    //
    // ```js
    // headers: (file) => ({ expires: file.meta.expires })
    // ```
    if (typeof headers === 'function') {
      opts.headers = headers(file);
    } else {
      Object.assign(opts.headers, this.opts.headers);
    }
    if (overrides) {
      Object.assign(opts.headers, overrides.headers);
    }
    if (file.xhrUpload) {
      Object.assign(opts.headers, file.xhrUpload.headers);
    }
    return opts;
  }

  // eslint-disable-next-line class-methods-use-this
  addMetadata(formData, meta, opts) {
    const allowedMetaFields = getAllowedMetaFields(opts.allowedMetaFields, meta);
    allowedMetaFields.forEach(item => {
      const value = meta[item];
      if (Array.isArray(value)) {
        // In this case we don't transform `item` to add brackets, it's up to
        // the user to add the brackets so it won't be overridden.
        value.forEach(subItem => formData.append(item, subItem));
      } else {
        formData.append(item, value);
      }
    });
  }
  createFormDataUpload(file, opts) {
    const formPost = new FormData();
    this.addMetadata(formPost, file.meta, opts);
    const dataWithUpdatedType = setTypeInBlob(file);
    if (file.name) {
      formPost.append(opts.fieldName, dataWithUpdatedType, file.meta.name);
    } else {
      formPost.append(opts.fieldName, dataWithUpdatedType);
    }
    return formPost;
  }
  createBundledUpload(files, opts) {
    const formPost = new FormData();
    const {
      meta
    } = this.uppy.getState();
    this.addMetadata(formPost, meta, opts);
    files.forEach(file => {
      const options = this.getOptions(file);
      const dataWithUpdatedType = setTypeInBlob(file);
      if (file.name) {
        formPost.append(options.fieldName, dataWithUpdatedType, file.name);
      } else {
        formPost.append(options.fieldName, dataWithUpdatedType);
      }
    });
    return formPost;
  }
  install() {
    if (this.opts.bundle) {
      const {
        capabilities
      } = this.uppy.getState();
      this.uppy.setState({
        capabilities: {
          ...capabilities,
          individualCancellation: false
        }
      });
    }
    this.uppy.addUploader(_classPrivateFieldLooseBase(this, _handleUpload)[_handleUpload]);
  }
  uninstall() {
    if (this.opts.bundle) {
      const {
        capabilities
      } = this.uppy.getState();
      this.uppy.setState({
        capabilities: {
          ...capabilities,
          individualCancellation: true
        }
      });
    }
    this.uppy.removeUploader(_classPrivateFieldLooseBase(this, _handleUpload)[_handleUpload]);
  }
}
async function _uploadLocalFile2(file) {
  const events = new EventManager(this.uppy);
  const controller = new AbortController();
  const uppyFetch = this.requests.wrapPromiseFunction(async () => {
    const opts = this.getOptions(file);
    const fetch = _classPrivateFieldLooseBase(this, _getFetcher)[_getFetcher]([file]);
    const body = opts.formData ? this.createFormDataUpload(file, opts) : file.data;
    return fetch(opts.endpoint, {
      ...opts,
      body,
      signal: controller.signal
    });
  });
  events.onFileRemove(file.id, () => controller.abort());
  events.onCancelAll(file.id, () => {
    controller.abort();
  });
  try {
    await uppyFetch().abortOn(controller.signal);
  } catch (error) {
    // TODO: create formal error with name 'AbortError' (this comes from RateLimitedQueue)
    if (error.message !== 'Cancelled') {
      throw error;
    }
  } finally {
    events.remove();
  }
}
async function _uploadBundle2(files) {
  const controller = new AbortController();
  const uppyFetch = this.requests.wrapPromiseFunction(async () => {
    var _this$uppy$getState$x;
    const optsFromState = (_this$uppy$getState$x = this.uppy.getState().xhrUpload) != null ? _this$uppy$getState$x : {};
    const fetch = _classPrivateFieldLooseBase(this, _getFetcher)[_getFetcher](files);
    const body = this.createBundledUpload(files, {
      ...this.opts,
      ...optsFromState
    });
    return fetch(this.opts.endpoint, {
      // headers can't be a function with bundle: true
      ...this.opts,
      body,
      signal: controller.signal
    });
  });
  function abort() {
    controller.abort();
  }

  // We only need to abort on cancel all because
  // individual cancellations are not possible with bundle: true
  this.uppy.once('cancel-all', abort);
  try {
    await uppyFetch().abortOn(controller.signal);
  } catch (error) {
    // TODO: create formal error with name 'AbortError' (this comes from RateLimitedQueue)
    if (error.message !== 'Cancelled') {
      throw error;
    }
  } finally {
    this.uppy.off('cancel-all', abort);
  }
}
function _getCompanionClientArgs2(file) {
  var _file$remote;
  const opts = this.getOptions(file);
  const allowedMetaFields = getAllowedMetaFields(opts.allowedMetaFields, file.meta);
  return {
    ...((_file$remote = file.remote) == null ? void 0 : _file$remote.body),
    protocol: 'multipart',
    endpoint: opts.endpoint,
    size: file.data.size,
    fieldname: opts.fieldName,
    metadata: Object.fromEntries(allowedMetaFields.map(name => [name, file.meta[name]])),
    httpMethod: opts.method,
    useFormData: opts.formData,
    headers: opts.headers
  };
}
async function _uploadFiles2(files) {
  await Promise.allSettled(files.map(file => {
    if (file.isRemote) {
      const getQueue = () => this.requests;
      const controller = new AbortController();
      const removedHandler = removedFile => {
        if (removedFile.id === file.id) controller.abort();
      };
      this.uppy.on('file-removed', removedHandler);
      const uploadPromise = this.uppy.getRequestClientForFile(file).uploadRemoteFile(file, _classPrivateFieldLooseBase(this, _getCompanionClientArgs)[_getCompanionClientArgs](file), {
        signal: controller.signal,
        getQueue
      });
      this.requests.wrapSyncFunction(() => {
        this.uppy.off('file-removed', removedHandler);
      }, {
        priority: -1
      })();
      return uploadPromise;
    }
    return _classPrivateFieldLooseBase(this, _uploadLocalFile)[_uploadLocalFile](file);
  }));
}
// eslint-disable-next-line global-require
XHRUpload.VERSION = packageJson.version;