import { Provider, tokenStorage, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { UppyFile, Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { UnknownProviderPluginState } from '@uppy/core/lib/Uppy.js';
export type ZoomOptions = CompanionPluginOptions;
export default class Zoom<M extends Meta, B extends Body> extends UIPlugin<ZoomOptions, M, B, UnknownProviderPluginState> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: typeof tokenStorage;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: ZoomOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Zoom.d.ts.map