import { type CompanionPluginOptions, Provider } from '@uppy/companion-client';
import type { AsyncStore, Body, Meta, UnknownProviderPlugin, UnknownProviderPluginState, UppyFile } from '@uppy/core';
import { UIPlugin, type Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import type { LocaleStrings } from '@uppy/utils';
import { type ComponentChild, h } from 'preact';
import locale from './locale.js';
export type ZoomOptions = CompanionPluginOptions & {
    locale?: LocaleStrings<typeof locale>;
};
export default class Zoom<M extends Meta, B extends Body> extends UIPlugin<ZoomOptions, M, B, UnknownProviderPluginState> implements UnknownProviderPlugin<M, B> {
    static VERSION: string;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: AsyncStore;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: ZoomOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Zoom.d.ts.map