import { createRequest as e } from "@urql/core";

export * from "@urql/core";

import * as r from "react";

import { toPromise as t, take as a, filter as n, onPush as u, subscribe as i, takeWhile as s, onEnd as o } from "wonka";

var c = {};

var v = r.createContext(c);

var f = v.Provider;

var l = v.Consumer;

v.displayName = "UrqlContext";

var useClient = () => {
  var e = r.useContext(v);
  if (e === c && "production" !== process.env.NODE_ENV) {
    var t = "No client has been specified using urql's Provider. please create a client and add a Provider.";
    console.error(t);
    throw new Error(t);
  }
  return e;
};

var d = {
  fetching: !1,
  stale: !1,
  hasNext: !1,
  error: void 0,
  data: void 0,
  extensions: void 0,
  operation: void 0
};

var areOperationsEqual = (e, r) => e === r || !(!e || !r || e.key !== r.key);

var computeNextState = (e, r) => {
  var t = {
    ...e,
    ...r,
    data: void 0 !== r.data || r.error ? r.data : e.data,
    fetching: !!r.fetching,
    stale: !!r.stale
  };
  return ((e, r) => {
    for (var t in e) {
      if (!(t in r)) {
        return !0;
      }
    }
    for (var a in r) {
      if ("operation" === a ? !areOperationsEqual(e[a], r[a]) : e[a] !== r[a]) {
        return !0;
      }
    }
    return !1;
  })(e, t) ? t : e;
};

var hasDepsChanged = (e, r) => {
  for (var t = 0, a = r.length; t < a; t++) {
    if (e[t] !== r[t]) {
      return !0;
    }
  }
  return !1;
};

var p = r.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;

function deferDispatch(e, r) {
  if ("production" !== process.env.NODE_ENV && p && p.ReactCurrentOwner && p.ReactCurrentOwner.current) {
    Promise.resolve(r).then(e);
  } else {
    e(r);
  }
}

function useMutation(i) {
  var s = r.useRef(!0);
  var o = useClient();
  var [c, v] = r.useState(d);
  var f = r.useCallback(((r, c) => {
    deferDispatch(v, {
      ...d,
      fetching: !0
    });
    return t(a(1)(n((e => !e.hasNext))(u((e => {
      if (s.current) {
        deferDispatch(v, {
          fetching: !1,
          stale: e.stale,
          data: e.data,
          error: e.error,
          extensions: e.extensions,
          operation: e.operation,
          hasNext: e.hasNext
        });
      }
    }))(o.executeMutation(e(i, r), c || {})))));
  }), [ o, i, v ]);
  r.useEffect((() => {
    s.current = !0;
    return () => {
      s.current = !1;
    };
  }), []);
  return [ c, f ];
}

function useRequest(t, a) {
  var n = r.useRef(void 0);
  return r.useMemo((() => {
    var r = e(t, a);
    if (void 0 !== n.current && n.current.key === r.key) {
      return n.current;
    } else {
      n.current = r;
      return r;
    }
  }), [ t, a ]);
}

var getCacheForClient = e => {
  if (!e._react) {
    var r = new Set;
    var t = new Map;
    if (e.operations$) {
      i((e => {
        if ("teardown" === e.kind && r.has(e.key)) {
          r.delete(e.key);
          t.delete(e.key);
        }
      }))(e.operations$);
    }
    e._react = {
      get: e => t.get(e),
      set(e, a) {
        r.delete(e);
        t.set(e, a);
      },
      dispose(e) {
        r.add(e);
      }
    };
  }
  return e._react;
};

var isSuspense = (e, r) => r && void 0 !== r.suspense ? !!r.suspense : e.suspense;

function useQuery(e) {
  var t = useClient();
  var a = getCacheForClient(t);
  var n = isSuspense(t, e.context);
  var c = useRequest(e.query, e.variables);
  var v = r.useMemo((() => {
    if (e.pause) {
      return null;
    }
    var r = t.executeQuery(c, {
      requestPolicy: e.requestPolicy,
      ...e.context
    });
    return n ? u((e => {
      a.set(c.key, e);
    }))(r) : r;
  }), [ a, t, c, n, e.pause, e.requestPolicy, e.context ]);
  var f = r.useCallback(((e, r) => {
    if (!e) {
      return {
        fetching: !1
      };
    }
    var t = a.get(c.key);
    if (!t) {
      var n;
      var u = i((e => {
        t = e;
        if (n) {
          n(t);
        }
      }))(s((() => r && !n || !t || "hasNext" in t && t.hasNext))(e));
      if (null == t && r) {
        var o = new Promise((e => {
          n = e;
        }));
        a.set(c.key, o);
        throw o;
      } else {
        u.unsubscribe();
      }
    } else if (r && null != t && "then" in t) {
      throw t;
    }
    return t || {
      fetching: !0
    };
  }), [ a, c ]);
  var l = [ t, c, e.requestPolicy, e.context, e.pause ];
  var [p, h] = r.useState((() => [ v, computeNextState(d, f(v, n)), l ]));
  var x = p[1];
  if (v !== p[0] && hasDepsChanged(p[2], l)) {
    h([ v, x = computeNextState(p[1], f(v, n)), l ]);
  }
  r.useEffect((() => {
    var e = p[0];
    var r = p[2][1];
    var t = !1;
    var updateResult = e => {
      t = !0;
      deferDispatch(h, (r => {
        var t = computeNextState(r[1], e);
        return r[1] !== t ? [ r[0], t, r[2] ] : r;
      }));
    };
    if (e) {
      var n = i(updateResult)(o((() => {
        updateResult({
          fetching: !1
        });
      }))(e));
      if (!t) {
        updateResult({
          fetching: !0
        });
      }
      return () => {
        a.dispose(r.key);
        n.unsubscribe();
      };
    } else {
      updateResult({
        fetching: !1
      });
    }
  }), [ a, p[0], p[2][1] ]);
  var y = r.useCallback((r => {
    var i = {
      requestPolicy: e.requestPolicy,
      ...e.context,
      ...r
    };
    deferDispatch(h, (e => [ n ? u((e => {
      a.set(c.key, e);
    }))(t.executeQuery(c, i)) : t.executeQuery(c, i), e[1], l ]));
  }), [ t, a, c, n, e.requestPolicy, e.context, e.pause ]);
  return [ x, y ];
}

function useSubscription(e, t) {
  var a = useClient();
  var n = useRequest(e.query, e.variables);
  var u = r.useRef(t);
  u.current = t;
  var s = r.useMemo((() => !e.pause ? a.executeSubscription(n, e.context) : null), [ a, n, e.pause, e.context ]);
  var c = [ a, n, e.context, e.pause ];
  var [v, f] = r.useState((() => [ s, {
    ...d,
    fetching: !!s
  }, c ]));
  var l = v[1];
  if (s !== v[0] && hasDepsChanged(v[2], c)) {
    f([ s, l = computeNextState(v[1], {
      fetching: !!s
    }), c ]);
  }
  r.useEffect((() => {
    var updateResult = e => {
      deferDispatch(f, (r => {
        var t = computeNextState(r[1], e);
        if (r[1] === t) {
          return r;
        }
        if (u.current && null != t.data && r[1].data !== t.data) {
          t.data = u.current(r[1].data, t.data);
        }
        return [ r[0], t, r[2] ];
      }));
    };
    if (v[0]) {
      return i(updateResult)(o((() => {
        updateResult({
          fetching: !!s
        });
      }))(v[0])).unsubscribe;
    } else {
      updateResult({
        fetching: !1
      });
    }
  }), [ v[0] ]);
  var p = r.useCallback((r => {
    var t = a.executeSubscription(n, {
      ...e.context,
      ...r
    });
    deferDispatch(f, (e => [ t, e[1], c ]));
  }), [ a, n, e.context, e.pause ]);
  return [ l, p ];
}

function Mutation(e) {
  var r = useMutation(e.query);
  return e.children({
    ...r[0],
    executeMutation: r[1]
  });
}

function Query(e) {
  var r = useQuery(e);
  return e.children({
    ...r[0],
    executeQuery: r[1]
  });
}

function Subscription(e) {
  var r = useSubscription(e, e.handler);
  return e.children({
    ...r[0],
    executeSubscription: r[1]
  });
}

export { l as Consumer, v as Context, Mutation, f as Provider, Query, Subscription, useClient, useMutation, useQuery, useSubscription };
//# sourceMappingURL=urql.es.js.map
