import { useCallback, useEffect, useRef, useState } from 'react';
import useDebouncedCallback from './useDebouncedCallback';
function valueEquality(left, right) {
    return left === right;
}
export default function useDebounce(value, delay, options) {
    var eq = (options && options.equalityFn) || valueEquality;
    var _a = useState(value), state = _a[0], dispatch = _a[1];
    var debounced = useDebouncedCallback(useCallback(function (value) { return dispatch(value); }, []), delay, options);
    var previousValue = useRef(value);
    useEffect(function () {
        // We need to use this condition otherwise we will run debounce timer for the first render (including maxWait option)
        if (!eq(previousValue.current, value)) {
            debounced.callback(value);
            previousValue.current = value;
        }
    }, [value, debounced, eq]);
    return [state, { cancel: debounced.cancel, pending: debounced.pending, flush: debounced.flush }];
}
