"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useDebouncedCallback_1 = require("./useDebouncedCallback");
function valueEquality(left, right) {
    return left === right;
}
function useDebounce(value, delay, options) {
    var eq = (options && options.equalityFn) || valueEquality;
    var _a = react_1.useState(value), state = _a[0], dispatch = _a[1];
    var debounced = useDebouncedCallback_1.default(react_1.useCallback(function (value) { return dispatch(value); }, []), delay, options);
    var previousValue = react_1.useRef(value);
    react_1.useEffect(function () {
        // We need to use this condition otherwise we will run debounce timer for the first render (including maxWait option)
        if (!eq(previousValue.current, value)) {
            debounced.callback(value);
            previousValue.current = value;
        }
    }, [value, debounced, eq]);
    return [state, { cancel: debounced.cancel, pending: debounced.pending, flush: debounced.flush }];
}
exports.default = useDebounce;
