# String utility methods

## Installation

```npm install ustring```

## API

```js
var ustring = require('ustring')
```

### toLowerFirst

```js
ustring.toLowerFirst('ABC') == 'aBC'
```

### toUpperFirstFirst

```js
ustring.toUpperFirst('abc') == 'Abc'
```

### hyphenate

```js
ustring.hyphenate('ThisIsMyWord') == 'this-is-my-word'
```

### humanize

```js
ustring.humanize('This_is-a-very-long-sentence') == 'This is a very long sentence'
```

### camelize

```js
ustring.camelize('This-is-a-very-long-word') == 'ThisIsAVeryLongWord'
```

### endsWith

```js
ustring.endsWith('hello world','world') == true
ustring.endsWith('hello world','wor') == false
ustring.endsWith(123, 3) == true
```

### is.alphanum

```js
ustring.is.alphanum('abcd09') == true
ustring.is.alphanum('abcd09#%#$') == false
```

### is.match

```js
ustring.is.match(/^[a-zA-Z0-9]+$/, 'abcd09') == true
ustring.is.match(/^[a-zA-Z0-9]+$/, 'abcd09#%#$') == false
```

Since match is a curried fn, you can even write

```js
var matches = ustring.is.match(/^[a-zA-Z0-9]+$/)
matches('abc')
```
<!--
### is.email

```js
ustring.is.email('me@test.com') == true
ustring.is.email('myemail.com') == false
```
 -->

### Tests

```
make
```

### License

MIT

