describe('endsWith', function(){

    var endsWith = require('../index').endsWith

    it('should work well', function(){

        endsWith('This-is-a-very-long-word','word')
            .should
            .equal(true)

        endsWith('This-is-a-very-long-word','wor')
            .should
            .equal(false)

    })

    it('should work for short strings', function(){
        endsWith('a','bc')
            .should
            .equal(false)
    })

    it('should handle empty string correctly', function(){
        endsWith('',0)
            .should
            .equal(false)

        endsWith('', '')
            .should
            .equal(true)

        endsWith(1, 0)
            .should
            .equal(false)

        endsWith(10, 0)
            .should
            .equal(true)

        endsWith(123, 23)
            .should
            .equal(true)
    })
})