/**
 * Create a context object for shared builder state.
 * @param {import('../types.js').ExtractionOptions} [options]
 *  Batch extraction options.
* @param {ReturnType<dictionaryContext>} [dictionaries]
 *  Context object for tracking dictionaries.
 */
export function builderContext(options?: import("../types.js").ExtractionOptions, dictionaries?: ReturnType<typeof dictionaryContext>): {
    batchType: (type: any) => any;
    builder(type: any): import("./builders/batch.js").BatchBuilder;
    dictionary(type: any): {
        type: import("../types.js").DictionaryType;
        values: import("./builders/batch.js").BatchBuilder;
        add(batch: any): any;
        key(value: any): any;
        finish(options: any): void;
    };
    finish: () => void;
};
/**
 * Returns a batch builder for the given type and builder context.
 * @param {import('../types.js').DataType} type A data type.
 * @param {ReturnType<builderContext>} [ctx] A builder context.
 * @returns {import('./builders/batch.js').BatchBuilder}
 */
export function builder(type: import("../types.js").DataType, ctx?: ReturnType<typeof builderContext>): import("./builders/batch.js").BatchBuilder;
import { dictionaryContext } from './builders/dictionary.js';
