/**
 * Create a new column from a provided data array.
 * @template T
 * @param {Array | import('../types.js').TypedArray} array The input data.
 * @param {import('../types.js').DataType} [type] The data type.
 *  If not specified, type inference is attempted.
 * @param {import('../types.js').ColumnBuilderOptions} [options]
 *  Builder options for the generated column.
 * @param {ReturnType<import('./builders/dictionary.js').dictionaryContext>} [dicts]
 *  Builder context object, for internal use only.
 * @returns {Column<T>} The generated column.
 */
export function columnFromArray<T>(array: any[] | import("../types.js").TypedArray, type?: import("../types.js").DataType, options?: import("../types.js").ColumnBuilderOptions, dicts?: ReturnType<typeof import("./builders/dictionary.js").dictionaryContext>): Column<T>;
import { Column } from '../column.js';
