/**
 * Create a new column by iterating over provided values.
 * @template T
 * @param {Iterable | ((callback: (value: any) => void) => void)} values
 *  Either an iterable object or a visitor function that applies a callback
 *  to successive data values (akin to Array.forEach).
 * @param {import('../types.js').DataType} [type] The data type.
 * @param {import('../types.js').ColumnBuilderOptions} [options]
 *  Builder options for the generated column.
 * @param {ReturnType<
 *    import('./builders/dictionary.js').dictionaryContext
 *  >} [dicts] Dictionary context object, for internal use only.
 * @returns {Column<T>} The generated column.
 */
export function columnFromValues<T>(values: Iterable<any> | ((callback: (value: any) => void) => void), type?: import("../types.js").DataType, options?: import("../types.js").ColumnBuilderOptions, dicts?: ReturnType<typeof import("./builders/dictionary.js").dictionaryContext>): Column<T>;
import { Column } from '../column.js';
