/**
 * Create a new table from a collection of columns. Columns are assumed
 * to have the same record batch sizes.
 * @param {[string, import('../column.js').Column][]
 *  | Record<string, import('../column.js').Column>} data The columns,
 *  as an object with name keys, or an array of [name, column] pairs.
 * @param {boolean} [useProxy] Flag indicating if row proxy
 *  objects should be used to represent table rows (default `false`).
 * @returns {Table} The new table.
 */
export function tableFromColumns(data: [string, import("../column.js").Column<any>][] | Record<string, import("../column.js").Column<any>>, useProxy?: boolean): Table;
import { Table } from '../table.js';
