export function invalidDataType(typeId: any): string;
export function field(name: string, type: import("./types.js").DataType, nullable?: boolean, metadata?: Map<string, string> | null): import("./types.js").Field;
export function dictionary(type: import("./types.js").DataType, indexType?: import("./types.js").IntType, ordered?: boolean, id?: number): import("./types.js").DictionaryType;
export function nullType(): import("./types.js").NullType;
export function int(bitWidth?: import("./types.js").IntBitWidth, signed?: boolean): import("./types.js").IntType;
export function int8(): import("./types.js").IntType;
export function int16(): import("./types.js").IntType;
export function int32(): import("./types.js").IntType;
export function int64(): import("./types.js").IntType;
export function uint8(): import("./types.js").IntType;
export function uint16(): import("./types.js").IntType;
export function uint32(): import("./types.js").IntType;
export function uint64(): import("./types.js").IntType;
export function float(precision?: import("./types.js").Precision_): import("./types.js").FloatType;
export function float16(): import("./types.js").FloatType;
export function float32(): import("./types.js").FloatType;
export function float64(): import("./types.js").FloatType;
export function binary(): import("./types.js").BinaryType;
export function utf8(): import("./types.js").Utf8Type;
export function bool(): import("./types.js").BoolType;
export function decimal(precision: number, scale: number, bitWidth?: 128 | 256): import("./types.js").DecimalType;
export function date(unit: import("./types.js").DateUnit_): import("./types.js").DateType;
export function dateDay(): import("./types.js").DateType;
export function dateMillisecond(): import("./types.js").DateType;
export function time(unit?: import("./types.js").TimeUnit_, bitWidth?: 32 | 64): import("./types.js").TimeType;
export function timeSecond(): import("./types.js").TimeType;
export function timeMillisecond(): import("./types.js").TimeType;
export function timeMicrosecond(): import("./types.js").TimeType;
export function timeNanosecond(): import("./types.js").TimeType;
export function timestamp(unit?: import("./types.js").TimeUnit_, timezone?: string | null): import("./types.js").TimestampType;
export function interval(unit?: import("./types.js").IntervalUnit_): import("./types.js").IntervalType;
export function list(child: FieldInput): import("./types.js").ListType;
export function struct(children: import("./types.js").Field[] | Record<string, import("./types.js").DataType>): import("./types.js").StructType;
export function union(mode: import("./types.js").UnionMode_, children: FieldInput[], typeIds?: number[], typeIdForValue?: (value: any, index: number) => number): import("./types.js").UnionType;
export function fixedSizeBinary(stride: number): import("./types.js").FixedSizeBinaryType;
export function fixedSizeList(child: FieldInput, stride: number): import("./types.js").FixedSizeListType;
export function mapType(keysSorted: boolean, child: import("./types.js").Field): import("./types.js").MapType;
export function map(keyField: FieldInput, valueField: FieldInput, keysSorted?: boolean): import("./types.js").MapType;
export function duration(unit?: import("./types.js").TimeUnit_): import("./types.js").DurationType;
export function largeBinary(): import("./types.js").LargeBinaryType;
export function largeUtf8(): import("./types.js").LargeUtf8Type;
export function largeList(child: FieldInput): import("./types.js").LargeListType;
export function runEndEncoded(runsField: FieldInput, valuesField: FieldInput): import("./types.js").RunEndEncodedType;
export function binaryView(): import("./types.js").BinaryViewType;
export function utf8View(): import("./types.js").Utf8ViewType;
export function listView(child: FieldInput): import("./types.js").ListViewType;
export function largeListView(child: FieldInput): import("./types.js").LargeListViewType;
export type FieldInput = import("./types.js").Field | import("./types.js").DataType;
