/**
 * Encode assembled data into Arrow IPC binary format.
 * @param {any} data Assembled table data.
 * @param {object} options Encoding options.
 * @param {import('./sink.js').Sink} [options.sink] IPC byte consumer.
 * @param {'stream' | 'file'} [options.format] Arrow stream or file format.
 * @returns {import('./sink.js').Sink} The sink that was passed in.
 */
export function encodeIPC(data: any, { sink, format }?: {
    sink?: import("./sink.js").Sink;
    format?: "stream" | "file";
}): import("./sink.js").Sink;
