/**
 * Encode an Arrow table into Arrow IPC binary format.
 * @param {import('../table.js').Table} table The Arrow table to encode.
 * @param {object} options Encoding options.
 * @param {import('./sink.js').Sink} [options.sink] IPC byte consumer.
 * @param {'stream' | 'file'} [options.format] Arrow stream or file format.
 * @returns {Uint8Array | null} The generated bytes (for an in-memory sink)
 *  or null (if using a sink that writes bytes elsewhere).
 */
export function tableToIPC(table: import("../table.js").Table, options: {
    sink?: import("./sink.js").Sink;
    format?: "stream" | "file";
}): Uint8Array | null;
