/*!
{
  "author": "Graham Fairweather",
  "copywrite": "Copyright (c) 2018-present",
  "date": "2020-01-14T15:27:52.362Z",
  "describe": "",
  "description": "Vue directive to react on clicks outside an element.",
  "file": "v-click-outside-x.js",
  "hash": "985cfe535e0f8da2f484",
  "license": "MIT",
  "version": "4.1.0"
}
*/
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["vClickOutsideX"] = factory();
	else
		root["vClickOutsideX"] = factory();
})((function () {
  'use strict';

  var ObjectCtr = {}.constructor;
  var objectPrototype = ObjectCtr.prototype;
  var defineProperty = ObjectCtr.defineProperty;
  var $globalThis;
  var getGlobalFallback = function() {
    if (typeof self !== 'undefined') {
      return self;
    }

    if (typeof window !== 'undefined') {
      return window;
    }

    if (typeof global !== 'undefined') {
      return global;
    }

    return void 0;
  };

  var returnThis = function() {
    return this;
  };

  try {
    if (defineProperty) {
      defineProperty(objectPrototype, '$$globalThis$$', {
        get: returnThis,
        configurable: true
      });
    } else {
      objectPrototype.__defineGetter__('$$globalThis$$', returnThis);
    }

    $globalThis = typeof $$globalThis$$ === 'undefined' ? getGlobalFallback() : $$globalThis$$;

    delete objectPrototype.$$globalThis$$;

    return $globalThis;
  } catch (error) {
    return getGlobalFallback();
  }
}()), function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module) {

module.exports = JSON.parse("{\"a\":\"4.1.0\"}");

/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "directive", function() { return directive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "install", function() { return install; });
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);
var _package_json__WEBPACK_IMPORTED_MODULE_0___namespace = /*#__PURE__*/__webpack_require__.t(0, 1);
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


/**
 * @typedef {import("../types/index.d.ts")} VClickOutsidePlugin
 */

var CLICK = 'click';
var captureInstances = Object.create(null);
var nonCaptureInstances = Object.create(null);
var captureEventHandlers = Object.create(null);
var nonCaptureEventHandlers = Object.create(null);
var instancesList = [captureInstances, nonCaptureInstances];
/**
 * The common event handler for bot capture and non-capture events.
 *
 * @param {!object} context - The event context.
 * @param {!object} instances - The capture or non-capture registered instances.
 * @param {Event} event - The event object.
 * @param {string} arg - The event type.
 * @returns {undefined} Default.
 */

var commonHandler = function onCommonEvent(context, instances, event, arg) {
  var target = event.target;

  var itemIteratee = function itemIteratee(item) {
    var el = item.el;

    if (el !== target && !el.contains(target)) {
      var binding = item.binding;

      if (binding.modifiers.stop) {
        event.stopPropagation();
      }

      if (binding.modifiers.prevent) {
        event.preventDefault();
      }

      binding.value.call(context, event);
    }
  };

  instances[arg].forEach(itemIteratee);
};
/**
 * Get the correct event handler: Capture or non-capture.
 *
 * @param {boolean} useCapture - Indicate which handler to use; 'true' to use
 *  capture handler or 'false' for non-capture.
 * @param {string} arg - The event type.
 * @returns {Function} - The event handler.
 */


var getEventHandler = function getEventHandler(useCapture, arg) {
  if (useCapture) {
    if (captureEventHandlers[arg]) {
      return captureEventHandlers[arg];
    }
    /**
     * Event handler for capture events.
     *
     * @param {Event} event - The event object.
     */


    captureEventHandlers[arg] = function onCaptureEvent(event) {
      commonHandler(this, captureInstances, event, arg);
    };

    return captureEventHandlers[arg];
  }

  if (nonCaptureEventHandlers[arg]) {
    return nonCaptureEventHandlers[arg];
  }
  /**
   * Event handler for non-capture events.
   *
   * @param {Event} event - The event object.
   */


  nonCaptureEventHandlers[arg] = function onNonCaptureEvent(event) {
    commonHandler(this, nonCaptureInstances, event, arg);
  };

  return nonCaptureEventHandlers[arg];
};
/**
 * The directive definition.
 * {@link https://vuejs.org/v2/guide/custom-directive.html|Custom directive}.
 *
 * @type {VClickOutsidePlugin.directive}
 * @property {!object} $captureInstances - Registered capture instances.
 * @property {!object} $nonCaptureInstances - Registered non-capture instances.
 * @property {Function} $_onCaptureEvent - Event handler for capture events.
 * @property {Function} $_onNonCaptureEvent - Event handler for non-capture events.
 * @property {Function} bind - Called only once, when the directive is first
 *  bound to the element.
 * @property {Function} unbind - Called only once, when the directive is unbound
 *  from the element.
 * @property {string} version - The version number of this release.
 */


var directive = Object.defineProperties({}, {
  $captureInstances: {
    value: captureInstances
  },
  $nonCaptureInstances: {
    value: nonCaptureInstances
  },
  $captureEventHandlers: {
    value: captureEventHandlers
  },
  $nonCaptureEventHandlers: {
    value: nonCaptureEventHandlers
  },
  bind: {
    value: function bind(el, binding) {
      if (typeof binding.value !== 'function') {
        throw new TypeError('Binding value must be a function.');
      }

      var arg = binding.arg || CLICK;

      var normalisedBinding = _objectSpread({}, binding, {}, {
        arg: arg,
        modifiers: _objectSpread({}, {
          capture: false,
          prevent: false,
          stop: false
        }, {}, binding.modifiers)
      });

      var useCapture = normalisedBinding.modifiers.capture;
      var instances = useCapture ? captureInstances : nonCaptureInstances;

      if (!Array.isArray(instances[arg])) {
        instances[arg] = [];
      }

      if (instances[arg].push({
        el: el,
        binding: normalisedBinding
      }) === 1) {
        /* istanbul ignore next */
        if ((typeof document === "undefined" ? "undefined" : _typeof(document)) === 'object' && document) {
          document.addEventListener(arg, getEventHandler(useCapture, arg), useCapture);
        }
      }
    }
  },
  unbind: {
    value: function unbind(el) {
      var compareElements = function compareElements(item) {
        return item.el !== el;
      };

      var instancesIteratee = function instancesIteratee(instances) {
        var instanceKeys = Object.keys(instances);

        if (instanceKeys.length) {
          var useCapture = instances === captureInstances;

          var keysIteratee = function keysIteratee(eventName) {
            var newInstance = instances[eventName].filter(compareElements);

            if (newInstance.length) {
              instances[eventName] = newInstance;
            } else {
              /* istanbul ignore next */
              if ((typeof document === "undefined" ? "undefined" : _typeof(document)) === 'object' && document) {
                document.removeEventListener(eventName, getEventHandler(useCapture, eventName), useCapture);
              }

              delete instances[eventName];
            }
          };

          instanceKeys.forEach(keysIteratee);
        }
      };

      instancesList.forEach(instancesIteratee);
    }
  },

  /* Note: This needs to be manually updated to match package.json. */
  version: {
    enumerable: true,
    value: _package_json__WEBPACK_IMPORTED_MODULE_0__[/* version */ "a"]
  }
});
/**
 * A Vue.js plugin should expose an install method. The method will be called
 * with the Vue constructor as the first argument, along with possible options.
 * {@link https://vuejs.org/v2/guide/plugins.html#Writing-a-Plugin|Writing a plugin}.
 *
 * @type {VClickOutsidePlugin.install}
 * @param {import("vue")} Vue - The Vue constructor.
 */

function install(Vue) {
  Vue.directive('click-outside', directive);
}



/***/ })
/******/ ]);
});
//# sourceMappingURL=v-click-outside-x.js.map