"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var testing_1 = require('@angular/core/testing');
var polymer_element_1 = require('./polymer-element');
var testing_2 = require('@angular/compiler/testing');
var core_1 = require('@angular/core');
var common_1 = require('@angular/common');
var by_1 = require('@angular/platform-browser/src/dom/debug/by');
var platform_browser_1 = require('@angular/platform-browser');
var testing_3 = require('@angular/platform-browser-dynamic/testing');
testing_1.setBaseTestProviders(testing_3.TEST_BROWSER_DYNAMIC_PLATFORM_PROVIDERS, testing_3.TEST_BROWSER_DYNAMIC_APPLICATION_PROVIDERS);
var Polymer = window.Polymer;
testing_1.describe('PolymerElement', function () {
    var tcb;
    var template;
    var testElement;
    var testComponent;
    var fixture;
    testing_1.it('is defined', function () {
        testing_1.expect(polymer_element_1.PolymerElement).toBeDefined();
    });
    testing_1.it('is function', function () {
        testing_1.expect(typeof polymer_element_1.PolymerElement).toBe('function');
    });
    beforeEach(function (done) {
        if (template) {
            testing_1.inject([testing_2.TestComponentBuilder], function (tcb) {
                tcb.overrideTemplate(TestComponent, template).createAsync(TestComponent).then(function (_fixture) {
                    fixture = _fixture;
                    testElement = _fixture.debugElement.query(by_1.By.css('test-element')).nativeElement;
                    testComponent = _fixture.componentInstance;
                    done();
                });
            })();
        }
        else {
            done();
        }
    });
    testing_1.describe('Developer experience', function () {
        testing_1.it('should throw an error for non-registered elements', function () {
            try {
                polymer_element_1.PolymerElement('non-registered');
            }
            catch (error) {
                testing_1.expect(error.message).toContain('element "non-registered" has not been registered');
            }
        });
    });
    testing_1.describe('Two-way data binding', function () {
        beforeAll(function () {
            template = "\n        <test-element\n          [(value)]=\"value\"\n          [(nestedObject)]=\"nestedObject\"\n          [(arrayObject)]=\"arrayObject\">\n        </test-element>\n        ";
        });
        testing_1.it('should have initial bound value', function () {
            fixture.detectChanges();
            testing_1.expect(testElement.value).toEqual('foo');
        });
        testing_1.it('should change value on bound value change', function () {
            testComponent.value = 'bar';
            fixture.detectChanges();
            testing_1.expect(testElement.value).toEqual('bar');
        });
        testing_1.it('should change bound value on value change', function () {
            testElement.value = 'bar';
            testing_1.expect(testComponent.value).toEqual('bar');
        });
        testing_1.it('should reflect change to a nested value (object)', function () {
            testComponent.nestedObject.value = 'foo';
            fixture.detectChanges();
            var nested = Polymer.dom(testElement.root).querySelector('#nested');
            testing_1.expect(nested.getAttribute('nested-object-value')).toEqual('foo');
        });
        testing_1.it('should reflect change to a nested value (array)', function () {
            testComponent.arrayObject.push('foo');
            fixture.detectChanges();
            var nested = Polymer.dom(testElement.root).querySelector('#nested');
            testing_1.expect(nested.getAttribute('array-object-value')).toEqual('foo');
        });
    });
    testing_1.describe('Form field', function () {
        var form;
        beforeAll(function () {
            template = "\n        <form [ngFormModel]=\"form\">\n          <test-element ngControl=\"value\" required></test-element>\n        </form>\n        ";
        });
        beforeEach(function () {
            form = new common_1.ControlGroup({ "value": new common_1.Control() });
            fixture.debugElement.componentInstance.form = form;
            fixture.detectChanges();
        });
        testing_1.describe('Initial state', function () {
            testing_1.it('should be initially pristine', function () {
                testing_1.expect(testElement.classList.contains('ng-pristine')).toEqual(true);
            });
            testing_1.it('should be initially untouched', function () {
                testing_1.expect(testElement.classList.contains('ng-untouched')).toEqual(true);
            });
            testing_1.it('should be invalid', function () {
                testing_1.expect(testElement.classList.contains('ng-invalid')).toEqual(true);
            });
            testing_1.it('should be an invalid form', function () {
                testing_1.expect(form.valid).toEqual(false);
            });
            testing_1.it('should not reflect invalid state to element initially', function () {
                testing_1.expect(testElement.invalid).toEqual(false);
            });
        });
        testing_1.describe('after value has changed', function () {
            beforeEach(function () {
                testElement.value = 'qux';
                fixture.detectChanges();
            });
            testing_1.it('should be dirty on value change', function () {
                testing_1.expect(testElement.classList.contains('ng-dirty')).toEqual(true);
            });
            testing_1.it('should be a valid form', function () {
                testing_1.expect(form.valid).toEqual(true);
            });
            testing_1.it('should have correct value', function () {
                testing_1.expect(form.value.value).toEqual('qux');
            });
            testing_1.it('should be valid', function () {
                testing_1.expect(testElement.classList.contains('ng-valid')).toEqual(true);
            });
            testing_1.it('should reflect invalid state to testElement when value changed', function () {
                testElement.value = '';
                fixture.detectChanges();
                testing_1.expect(testElement.invalid).toEqual(true);
            });
        });
    });
    testing_1.describe('Light dom content', function () {
        beforeAll(function () {
            template = "\n        <test-element [(value)]=\"value\" class=\"hascontent\">\n          <div class=\"foo\">Foo</div>\n          <div class=\"bar selected\" *ngIf=\"barVisible\">Bar</div>\n          <div class=\"bar2\" *ngIf=\"barVisible\">Bar2</div>\n          <div class=\"baz selected\">Baz</div>\n          Qux\n\n        </test-element>\n        ";
        });
        beforeEach(function (done) {
            setTimeout(done, 0);
        });
        function contentParentChildren(contentParentId) {
            var selected = testElement.$[contentParentId];
            return Polymer.dom(selected).getDistributedNodes();
        }
        function containsChild(contentParentId, childClassName) {
            var children = contentParentChildren(contentParentId);
            return Array.prototype.filter.call(children, function (node) {
                return node.classList && node.classList.contains(childClassName);
            }).length > 0;
        }
        testing_1.it('should distribute correctly', function () {
            // Local dom
            testing_1.expect(containsChild('selected', 'foo')).toEqual(false);
            testing_1.expect(containsChild('all', 'foo')).toEqual(true);
            testing_1.expect(containsChild('selected', 'bar')).toEqual(false);
            testing_1.expect(containsChild('all', 'bar')).toEqual(false);
            testing_1.expect(containsChild('selected', 'baz')).toEqual(true);
            var hasQux = Array.prototype.filter.call(contentParentChildren('all'), function (node) {
                return node.textContent.indexOf('Qux') !== -1;
            });
            testing_1.expect(hasQux.length).toEqual(1);
            // Light dom
            testing_1.expect(Polymer.dom(testElement).querySelector('.foo')).not.toEqual(null);
        });
        testing_1.it('should support ngif', function (done) {
            testComponent.barVisible = true;
            fixture.detectChanges();
            // Distribution with polyfills is done with MutationObservers, so it is asynchronous
            setTimeout(function () {
                testing_1.expect(containsChild('selected', 'bar')).toEqual(true);
                testing_1.expect(containsChild('all', 'bar2')).toEqual(true);
                done();
            }, 0);
        });
    });
    testing_1.describe('DOM API', function () {
        beforeAll(function () {
            template = "\n        <test-element [(value)]=\"value\" class=\"hascontent\">\n          <div class=\"foo\" *ngFor=\"let item of arrayObject\">Foo {{item}}</div>\n          <div class=\"bar selected\" *ngIf=\"barVisible\">Bar</div>\n          <div class=\"bar2\" *ngIf=\"barVisible\">Bar2</div>\n          <div class=\"baz selected\">Baz</div>\n        </test-element>\n        ";
        });
        testing_1.it('should trigger one mutation after multiple operations', function (done) {
            var observerSpy = jasmine.createSpy('observerSpy');
            var domApi = Polymer.dom(testElement).observeNodes(observerSpy);
            testComponent.arrayObject = [1, 2, 3];
            fixture.detectChanges();
            testComponent.arrayObject.push(4);
            fixture.detectChanges();
            testComponent.arrayObject.pop();
            fixture.detectChanges();
            testComponent.arrayObject = [0, 1, 2];
            fixture.detectChanges();
            testComponent.barVisible = true;
            fixture.detectChanges();
            testComponent.barVisible = false;
            fixture.detectChanges();
            setTimeout(function () {
                testing_1.expect(observerSpy).toHaveBeenCalledTimes(1);
                done();
            }, 0);
        });
        testing_1.it('should have the correct adapter', function () {
            var functionName = function (fun) {
                var ret = fun.toString();
                ret = ret.substr('function '.length);
                ret = ret.substr(0, ret.indexOf('('));
                return ret;
            };
            var dom = platform_browser_1.__platform_browser_private__.getDOM();
            var adapterName = functionName(dom.constructor);
            if (Polymer.Settings.useShadow) {
                testing_1.expect(adapterName).toEqual("PolymerDomAdapter");
            }
            else {
                testing_1.expect(adapterName).toEqual("PolymerShadyDomAdapter");
            }
        });
    });
});
var TestComponent = (function () {
    function TestComponent() {
        this.value = 'foo';
        this.nestedObject = { value: undefined };
        this.arrayObject = [];
        this.barVisible = false;
    }
    TestComponent = __decorate([
        core_1.Component({
            selector: 'test-component',
            template: "",
            directives: [polymer_element_1.PolymerElement('test-element')]
        }), 
        __metadata('design:paramtypes', [])
    ], TestComponent);
    return TestComponent;
}());
//# sourceMappingURL=data:application/json;base64,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