/**
 * @license
 * Copyright (c) 2021 - 2024 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */

/**
 * Get the scrollLeft value of the element relative to the direction
 */
export declare function getNormalizedScrollLeft(element: HTMLElement, direction: string | null): number;

/**
 * Set the scrollLeft value of the element relative to the direction
 */
export declare function setNormalizedScrollLeft(
  element: HTMLElement,
  direction: string | null,
  scrollLeft: number,
): void;
