/**
 * @license
 * Copyright (c) 2023 - 2024 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */

/**
 * Checks if two paths match based on their origin, pathname, and query parameters.
 *
 * The function matches an actual URL against an expected URL to see if they share
 * the same base origin (like https://example.com), the same path (like /path/to/page),
 * and if the actual URL contains at least all the query parameters with the same values
 * from the expected URL.
 */
export declare function matchPaths(actual: string, expected: string): boolean;
