(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Vaadin = global.Vaadin || {}));
}(this, (function (exports) { 'use strict';

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);
      if (object === null) break;
    }

    return object;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get(target, property, receiver || target);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function toArray(objectOrArray) {
    objectOrArray = objectOrArray || [];
    return Array.isArray(objectOrArray) ? objectOrArray : [objectOrArray];
  }
  function log(msg) {
    return "[Vaadin.Router] ".concat(msg);
  }
  function logValue(value) {
    if (_typeof(value) !== 'object') {
      return String(value);
    }

    var stringType = Object.prototype.toString.call(value).match(/ (.*)\]$/)[1];

    if (stringType === 'Object' || stringType === 'Array') {
      return "".concat(stringType, " ").concat(JSON.stringify(value));
    } else {
      return stringType;
    }
  }
  var MODULE = 'module';
  var NOMODULE = 'nomodule';
  var bundleKeys = [MODULE, NOMODULE];

  function ensureBundle(src) {
    if (!src.match(/.+\.[m]?js$/)) {
      throw new Error(log("Unsupported type for bundle \"".concat(src, "\": .js or .mjs expected.")));
    }
  }

  function ensureRoute(route) {
    if (!route || !isString(route.path)) {
      throw new Error(log("Expected route config to be an object with a \"path\" string property, or an array of such objects"));
    }

    var bundle = route.bundle;
    var stringKeys = ['component', 'redirect', 'bundle'];

    if (!isFunction(route.action) && !Array.isArray(route.children) && !isFunction(route.children) && !isObject(bundle) && !stringKeys.some(function (key) {
      return isString(route[key]);
    })) {
      throw new Error(log("Expected route config \"".concat(route.path, "\" to include either \"").concat(stringKeys.join('", "'), "\" ") + "or \"action\" function but none found."));
    }

    if (bundle) {
      if (isString(bundle)) {
        ensureBundle(bundle);
      } else if (!bundleKeys.some(function (key) {
        return key in bundle;
      })) {
        throw new Error(log('Expected route bundle to include either "' + NOMODULE + '" or "' + MODULE + '" keys, or both'));
      } else {
        bundleKeys.forEach(function (key) {
          return key in bundle && ensureBundle(bundle[key]);
        });
      }
    }

    if (route.redirect) {
      ['bundle', 'component'].forEach(function (overriddenProp) {
        if (overriddenProp in route) {
          console.warn(log("Route config \"".concat(route.path, "\" has both \"redirect\" and \"").concat(overriddenProp, "\" properties, ") + "and \"redirect\" will always override the latter. Did you mean to only use \"".concat(overriddenProp, "\"?")));
        }
      });
    }
  }
  function ensureRoutes(routes) {
    toArray(routes).forEach(function (route) {
      return ensureRoute(route);
    });
  }

  function loadScript(src, key) {
    var script = document.head.querySelector('script[src="' + src + '"][async]');

    if (!script) {
      script = document.createElement('script');
      script.setAttribute('src', src);

      if (key === MODULE) {
        script.setAttribute('type', MODULE);
      } else if (key === NOMODULE) {
        script.setAttribute(NOMODULE, '');
      }

      script.async = true;
    }

    return new Promise(function (resolve, reject) {
      script.onreadystatechange = script.onload = function (e) {
        script.__dynamicImportLoaded = true;
        resolve(e);
      };

      script.onerror = function (e) {
        if (script.parentNode) {
          script.parentNode.removeChild(script);
        }

        reject(e);
      };

      if (script.parentNode === null) {
        document.head.appendChild(script);
      } else if (script.__dynamicImportLoaded) {
        resolve();
      }
    });
  }

  function loadBundle(bundle) {
    if (isString(bundle)) {
      return loadScript(bundle);
    } else {
      return Promise.race(bundleKeys.filter(function (key) {
        return key in bundle;
      }).map(function (key) {
        return loadScript(bundle[key], key);
      }));
    }
  }
  function fireRouterEvent(type, detail) {
    return !window.dispatchEvent(new CustomEvent("vaadin-router-".concat(type), {
      cancelable: type === 'go',
      detail: detail
    }));
  }
  function isObject(o) {
    // guard against null passing the typeof check
    return _typeof(o) === 'object' && !!o;
  }
  function isFunction(f) {
    return typeof f === 'function';
  }
  function isString(s) {
    return typeof s === 'string';
  }
  function getNotFoundError(context) {
    var error = new Error(log("Page not found (".concat(context.pathname, ")")));
    error.context = context;
    error.code = 404;
    return error;
  }
  var notFoundResult = new function NotFoundResult() {
    _classCallCheck(this, NotFoundResult);
  }();

  /* istanbul ignore next: coverage is calculated in Chrome, this code is for IE */

  function getAnchorOrigin(anchor) {
    // IE11: on HTTP and HTTPS the default port is not included into
    // window.location.origin, so won't include it here either.
    var port = anchor.port;
    var protocol = anchor.protocol;
    var defaultHttp = protocol === 'http:' && port === '80';
    var defaultHttps = protocol === 'https:' && port === '443';
    var host = defaultHttp || defaultHttps ? anchor.hostname // does not include the port number (e.g. www.example.org)
    : anchor.host; // does include the port number (e.g. www.example.org:80)

    return "".concat(protocol, "//").concat(host);
  } // The list of checks is not complete:
  //  - SVG support is missing
  //  - the 'rel' attribute is not considered


  function vaadinRouterGlobalClickHandler(event) {
    // ignore the click if the default action is prevented
    if (event.defaultPrevented) {
      return;
    } // ignore the click if not with the primary mouse button


    if (event.button !== 0) {
      return;
    } // ignore the click if a modifier key is pressed


    if (event.shiftKey || event.ctrlKey || event.altKey || event.metaKey) {
      return;
    } // find the <a> element that the click is at (or within)


    var anchor = event.target;
    var path = event.composedPath ? event.composedPath() : event.path || []; // FIXME(web-padawan): `Symbol.iterator` used by webcomponentsjs is broken for arrays
    // example to check: `for...of` loop here throws the "Not yet implemented" error

    for (var i = 0; i < path.length; i++) {
      var target = path[i];

      if (target.nodeName && target.nodeName.toLowerCase() === 'a') {
        anchor = target;
        break;
      }
    }

    while (anchor && anchor.nodeName.toLowerCase() !== 'a') {
      anchor = anchor.parentNode;
    } // ignore the click if not at an <a> element


    if (!anchor || anchor.nodeName.toLowerCase() !== 'a') {
      return;
    } // ignore the click if the <a> element has a non-default target


    if (anchor.target && anchor.target.toLowerCase() !== '_self') {
      return;
    } // ignore the click if the <a> element has the 'download' attribute


    if (anchor.hasAttribute('download')) {
      return;
    } // ignore the click if the <a> element has the 'router-ignore' attribute


    if (anchor.hasAttribute('router-ignore')) {
      return;
    } // ignore the click if the target URL is a fragment on the current page


    if (anchor.pathname === window.location.pathname && anchor.hash !== '') {
      return;
    } // ignore the click if the target is external to the app
    // In IE11 HTMLAnchorElement does not have the `origin` property


    var origin = anchor.origin || getAnchorOrigin(anchor);

    if (origin !== window.location.origin) {
      return;
    } // if none of the above, convert the click into a navigation event


    var _anchor = anchor,
        pathname = _anchor.pathname,
        search = _anchor.search,
        hash = _anchor.hash;

    if (fireRouterEvent('go', {
      pathname: pathname,
      search: search,
      hash: hash
    })) {
      event.preventDefault(); // for a click event, the scroll is reset to the top position.

      if (event && event.type === 'click') {
        window.scrollTo(0, 0);
      }
    }
  }
  /**
   * A navigation trigger for Vaadin Router that translated clicks on `<a>` links
   * into Vaadin Router navigation events.
   *
   * Only regular clicks on in-app links are translated (primary mouse button, no
   * modifier keys, the target href is within the app's URL space).
   *
   * @memberOf Router.NavigationTrigger
   * @type {NavigationTrigger}
   */


  var CLICK = {
    activate: function activate() {
      window.document.addEventListener('click', vaadinRouterGlobalClickHandler);
    },
    inactivate: function inactivate() {
      window.document.removeEventListener('click', vaadinRouterGlobalClickHandler);
    }
  };

  var isIE = /Trident/.test(navigator.userAgent);
  /* istanbul ignore next: coverage is calculated in Chrome, this code is for IE */

  if (isIE && !isFunction(window.PopStateEvent)) {
    window.PopStateEvent = function (inType, params) {
      params = params || {};
      var e = document.createEvent('Event');
      e.initEvent(inType, Boolean(params.bubbles), Boolean(params.cancelable));
      e.state = params.state || null;
      return e;
    };

    window.PopStateEvent.prototype = window.Event.prototype;
  }

  function vaadinRouterGlobalPopstateHandler(event) {
    if (event.state === 'vaadin-router-ignore') {
      return;
    }

    var _window$location = window.location,
        pathname = _window$location.pathname,
        search = _window$location.search,
        hash = _window$location.hash;
    fireRouterEvent('go', {
      pathname: pathname,
      search: search,
      hash: hash
    });
  }
  /**
   * A navigation trigger for Vaadin Router that translates popstate events into
   * Vaadin Router navigation events.
   *
   * @memberOf Router.NavigationTrigger
   * @type {NavigationTrigger}
   */


  var POPSTATE = {
    activate: function activate() {
      window.addEventListener('popstate', vaadinRouterGlobalPopstateHandler);
    },
    inactivate: function inactivate() {
      window.removeEventListener('popstate', vaadinRouterGlobalPopstateHandler);
    }
  };

  /**
   * Expose `pathToRegexp`.
   */
  var pathToRegexp_1 = pathToRegexp;
  var parse_1 = parse;
  var compile_1 = compile;
  var tokensToFunction_1 = tokensToFunction;
  var tokensToRegExp_1 = tokensToRegExp;
  /**
   * Default configs.
   */

  var DEFAULT_DELIMITER = '/';
  var DEFAULT_DELIMITERS = './';
  /**
   * The main path matching regexp utility.
   *
   * @type {RegExp}
   */

  var PATH_REGEXP = new RegExp([// Match escaped characters that would otherwise appear in future matches.
  // This allows the user to escape special characters that won't transform.
  '(\\\\.)', // Match Express-style parameters and un-named parameters with a prefix
  // and optional suffixes. Matches appear as:
  //
  // ":test(\\d+)?" => ["test", "\d+", undefined, "?"]
  // "(\\d+)"  => [undefined, undefined, "\d+", undefined]
  '(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?'].join('|'), 'g');
  /**
   * Parse a string for the raw tokens.
   *
   * @param  {string}  str
   * @param  {Object=} options
   * @return {!Array}
   */

  function parse(str, options) {
    var tokens = [];
    var key = 0;
    var index = 0;
    var path = '';
    var defaultDelimiter = options && options.delimiter || DEFAULT_DELIMITER;
    var delimiters = options && options.delimiters || DEFAULT_DELIMITERS;
    var pathEscaped = false;
    var res;

    while ((res = PATH_REGEXP.exec(str)) !== null) {
      var m = res[0];
      var escaped = res[1];
      var offset = res.index;
      path += str.slice(index, offset);
      index = offset + m.length; // Ignore already escaped sequences.

      if (escaped) {
        path += escaped[1];
        pathEscaped = true;
        continue;
      }

      var prev = '';
      var next = str[index];
      var name = res[2];
      var capture = res[3];
      var group = res[4];
      var modifier = res[5];

      if (!pathEscaped && path.length) {
        var k = path.length - 1;

        if (delimiters.indexOf(path[k]) > -1) {
          prev = path[k];
          path = path.slice(0, k);
        }
      } // Push the current path onto the tokens.


      if (path) {
        tokens.push(path);
        path = '';
        pathEscaped = false;
      }

      var partial = prev !== '' && next !== undefined && next !== prev;
      var repeat = modifier === '+' || modifier === '*';
      var optional = modifier === '?' || modifier === '*';
      var delimiter = prev || defaultDelimiter;
      var pattern = capture || group;
      tokens.push({
        name: name || key++,
        prefix: prev,
        delimiter: delimiter,
        optional: optional,
        repeat: repeat,
        partial: partial,
        pattern: pattern ? escapeGroup(pattern) : '[^' + escapeString(delimiter) + ']+?'
      });
    } // Push any remaining characters.


    if (path || index < str.length) {
      tokens.push(path + str.substr(index));
    }

    return tokens;
  }
  /**
   * Compile a string to a template function for the path.
   *
   * @param  {string}             str
   * @param  {Object=}            options
   * @return {!function(Object=, Object=)}
   */


  function compile(str, options) {
    return tokensToFunction(parse(str, options));
  }
  /**
   * Expose a method for transforming tokens into the path function.
   */


  function tokensToFunction(tokens) {
    // Compile all the tokens into regexps.
    var matches = new Array(tokens.length); // Compile all the patterns before compilation.

    for (var i = 0; i < tokens.length; i++) {
      if (_typeof(tokens[i]) === 'object') {
        matches[i] = new RegExp('^(?:' + tokens[i].pattern + ')$');
      }
    }

    return function (data, options) {
      var path = '';
      var encode = options && options.encode || encodeURIComponent;

      for (var i = 0; i < tokens.length; i++) {
        var token = tokens[i];

        if (typeof token === 'string') {
          path += token;
          continue;
        }

        var value = data ? data[token.name] : undefined;
        var segment;

        if (Array.isArray(value)) {
          if (!token.repeat) {
            throw new TypeError('Expected "' + token.name + '" to not repeat, but got array');
          }

          if (value.length === 0) {
            if (token.optional) continue;
            throw new TypeError('Expected "' + token.name + '" to not be empty');
          }

          for (var j = 0; j < value.length; j++) {
            segment = encode(value[j], token);

            if (!matches[i].test(segment)) {
              throw new TypeError('Expected all "' + token.name + '" to match "' + token.pattern + '"');
            }

            path += (j === 0 ? token.prefix : token.delimiter) + segment;
          }

          continue;
        }

        if (typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean') {
          segment = encode(String(value), token);

          if (!matches[i].test(segment)) {
            throw new TypeError('Expected "' + token.name + '" to match "' + token.pattern + '", but got "' + segment + '"');
          }

          path += token.prefix + segment;
          continue;
        }

        if (token.optional) {
          // Prepend partial segment prefixes.
          if (token.partial) path += token.prefix;
          continue;
        }

        throw new TypeError('Expected "' + token.name + '" to be ' + (token.repeat ? 'an array' : 'a string'));
      }

      return path;
    };
  }
  /**
   * Escape a regular expression string.
   *
   * @param  {string} str
   * @return {string}
   */


  function escapeString(str) {
    return str.replace(/([.+*?=^!:${}()[\]|/\\])/g, '\\$1');
  }
  /**
   * Escape the capturing group by escaping special characters and meaning.
   *
   * @param  {string} group
   * @return {string}
   */


  function escapeGroup(group) {
    return group.replace(/([=!:$/()])/g, '\\$1');
  }
  /**
   * Get the flags for a regexp from the options.
   *
   * @param  {Object} options
   * @return {string}
   */


  function flags(options) {
    return options && options.sensitive ? '' : 'i';
  }
  /**
   * Pull out keys from a regexp.
   *
   * @param  {!RegExp} path
   * @param  {Array=}  keys
   * @return {!RegExp}
   */


  function regexpToRegexp(path, keys) {
    if (!keys) return path; // Use a negative lookahead to match only capturing groups.

    var groups = path.source.match(/\((?!\?)/g);

    if (groups) {
      for (var i = 0; i < groups.length; i++) {
        keys.push({
          name: i,
          prefix: null,
          delimiter: null,
          optional: false,
          repeat: false,
          partial: false,
          pattern: null
        });
      }
    }

    return path;
  }
  /**
   * Transform an array into a regexp.
   *
   * @param  {!Array}  path
   * @param  {Array=}  keys
   * @param  {Object=} options
   * @return {!RegExp}
   */


  function arrayToRegexp(path, keys, options) {
    var parts = [];

    for (var i = 0; i < path.length; i++) {
      parts.push(pathToRegexp(path[i], keys, options).source);
    }

    return new RegExp('(?:' + parts.join('|') + ')', flags(options));
  }
  /**
   * Create a path regexp from string input.
   *
   * @param  {string}  path
   * @param  {Array=}  keys
   * @param  {Object=} options
   * @return {!RegExp}
   */


  function stringToRegexp(path, keys, options) {
    return tokensToRegExp(parse(path, options), keys, options);
  }
  /**
   * Expose a function for taking tokens and returning a RegExp.
   *
   * @param  {!Array}  tokens
   * @param  {Array=}  keys
   * @param  {Object=} options
   * @return {!RegExp}
   */


  function tokensToRegExp(tokens, keys, options) {
    options = options || {};
    var strict = options.strict;
    var start = options.start !== false;
    var end = options.end !== false;
    var delimiter = escapeString(options.delimiter || DEFAULT_DELIMITER);
    var delimiters = options.delimiters || DEFAULT_DELIMITERS;
    var endsWith = [].concat(options.endsWith || []).map(escapeString).concat('$').join('|');
    var route = start ? '^' : '';
    var isEndDelimited = tokens.length === 0; // Iterate over the tokens and create our regexp string.

    for (var i = 0; i < tokens.length; i++) {
      var token = tokens[i];

      if (typeof token === 'string') {
        route += escapeString(token);
        isEndDelimited = i === tokens.length - 1 && delimiters.indexOf(token[token.length - 1]) > -1;
      } else {
        var capture = token.repeat ? '(?:' + token.pattern + ')(?:' + escapeString(token.delimiter) + '(?:' + token.pattern + '))*' : token.pattern;
        if (keys) keys.push(token);

        if (token.optional) {
          if (token.partial) {
            route += escapeString(token.prefix) + '(' + capture + ')?';
          } else {
            route += '(?:' + escapeString(token.prefix) + '(' + capture + '))?';
          }
        } else {
          route += escapeString(token.prefix) + '(' + capture + ')';
        }
      }
    }

    if (end) {
      if (!strict) route += '(?:' + delimiter + ')?';
      route += endsWith === '$' ? '$' : '(?=' + endsWith + ')';
    } else {
      if (!strict) route += '(?:' + delimiter + '(?=' + endsWith + '))?';
      if (!isEndDelimited) route += '(?=' + delimiter + '|' + endsWith + ')';
    }

    return new RegExp(route, flags(options));
  }
  /**
   * Normalize the given path string, returning a regular expression.
   *
   * An empty array can be passed in for the keys, which will hold the
   * placeholder key descriptions. For example, using `/user/:id`, `keys` will
   * contain `[{ name: 'id', delimiter: '/', optional: false, repeat: false }]`.
   *
   * @param  {(string|RegExp|Array)} path
   * @param  {Array=}                keys
   * @param  {Object=}               options
   * @return {!RegExp}
   */


  function pathToRegexp(path, keys, options) {
    if (path instanceof RegExp) {
      return regexpToRegexp(path, keys);
    }

    if (Array.isArray(path)) {
      return arrayToRegexp(
      /** @type {!Array} */
      path, keys, options);
    }

    return stringToRegexp(
    /** @type {string} */
    path, keys, options);
  }
  pathToRegexp_1.parse = parse_1;
  pathToRegexp_1.compile = compile_1;
  pathToRegexp_1.tokensToFunction = tokensToFunction_1;
  pathToRegexp_1.tokensToRegExp = tokensToRegExp_1;

  /**
   * Universal Router (https://www.kriasoft.com/universal-router/)
   *
   * Copyright (c) 2015-present Kriasoft.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.txt file in the root directory of this source tree.
   */
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var cache = new Map(); // see https://github.com/pillarjs/path-to-regexp/issues/148

  cache.set('|false', {
    keys: [],
    pattern: /(?:)/
  });

  function decodeParam(val) {
    try {
      return decodeURIComponent(val);
    } catch (err) {
      return val;
    }
  }

  function matchPath(routepath, path, exact, parentKeys, parentParams) {
    exact = !!exact;
    var cacheKey = "".concat(routepath, "|").concat(exact);
    var regexp = cache.get(cacheKey);

    if (!regexp) {
      var keys = [];
      regexp = {
        keys: keys,
        pattern: pathToRegexp_1(routepath, keys, {
          end: exact,
          strict: routepath === ''
        })
      };
      cache.set(cacheKey, regexp);
    }

    var m = regexp.pattern.exec(path);

    if (!m) {
      return null;
    }

    var params = Object.assign({}, parentParams);

    for (var i = 1; i < m.length; i++) {
      var key = regexp.keys[i - 1];
      var prop = key.name;
      var value = m[i];

      if (value !== undefined || !hasOwnProperty.call(params, prop)) {
        if (key.repeat) {
          params[prop] = value ? value.split(key.delimiter).map(decodeParam) : [];
        } else {
          params[prop] = value ? decodeParam(value) : value;
        }
      }
    }

    return {
      path: m[0],
      keys: (parentKeys || []).concat(regexp.keys),
      params: params
    };
  }

  /**
   * Universal Router (https://www.kriasoft.com/universal-router/)
   *
   * Copyright (c) 2015-present Kriasoft.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.txt file in the root directory of this source tree.
   */
  /**
   * Traverses the routes tree and matches its nodes to the given pathname from
   * the root down to the leaves. Each match consumes a part of the pathname and
   * the matching process continues for as long as there is a matching child
   * route for the remaining part of the pathname.
   *
   * The returned value is a lazily evaluated iterator.
   *
   * The leading "/" in a route path matters only for the root of the routes
   * tree (or if all parent routes are ""). In all other cases a leading "/" in
   * a child route path has no significance.
   *
   * The trailing "/" in a _route path_ matters only for the leaves of the
   * routes tree. A leaf route with a trailing "/" matches only a pathname that
   * also has a trailing "/".
   *
   * The trailing "/" in a route path does not affect matching of child routes
   * in any way.
   *
   * The trailing "/" in a _pathname_ generally does not matter (except for
   * the case of leaf nodes described above).
   *
   * The "" and "/" routes have special treatment:
   *  1. as a single route
   *     the "" and "/" routes match only the "" and "/" pathnames respectively
   *  2. as a parent in the routes tree
   *     the "" route matches any pathname without consuming any part of it
   *     the "/" route matches any absolute pathname consuming its leading "/"
   *  3. as a leaf in the routes tree
   *     the "" and "/" routes match only if the entire pathname is consumed by
   *         the parent routes chain. In this case "" and "/" are equivalent.
   *  4. several directly nested "" or "/" routes
   *     - directly nested "" or "/" routes are 'squashed' (i.e. nesting two
   *       "/" routes does not require a double "/" in the pathname to match)
   *     - if there are only "" in the parent routes chain, no part of the
   *       pathname is consumed, and the leading "/" in the child routes' paths
   *       remains significant
   *
   * Side effect:
   *   - the routes tree { path: '' } matches only the '' pathname
   *   - the routes tree { path: '', children: [ { path: '' } ] } matches any
   *     pathname (for the tree root)
   *
   * Prefix matching can be enabled also by `children: true`.
   */

  function matchRoute(route, pathname, ignoreLeadingSlash, parentKeys, parentParams) {
    var match;
    var childMatches;
    var childIndex = 0;
    var routepath = route.path || '';

    if (routepath.charAt(0) === '/') {
      if (ignoreLeadingSlash) {
        routepath = routepath.substr(1);
      }

      ignoreLeadingSlash = true;
    }

    return {
      next: function next(routeToSkip) {
        if (route === routeToSkip) {
          return {
            done: true
          };
        }

        var children = route.__children = route.__children || route.children;

        if (!match) {
          match = matchPath(routepath, pathname, !children, parentKeys, parentParams);

          if (match) {
            return {
              done: false,
              value: {
                route: route,
                keys: match.keys,
                params: match.params,
                path: match.path
              }
            };
          }
        }

        if (match && children) {
          while (childIndex < children.length) {
            if (!childMatches) {
              var childRoute = children[childIndex];
              childRoute.parent = route;
              var matchedLength = match.path.length;

              if (matchedLength > 0 && pathname.charAt(matchedLength) === '/') {
                matchedLength += 1;
              }

              childMatches = matchRoute(childRoute, pathname.substr(matchedLength), ignoreLeadingSlash, match.keys, match.params);
            }

            var childMatch = childMatches.next(routeToSkip);

            if (!childMatch.done) {
              return {
                done: false,
                value: childMatch.value
              };
            }

            childMatches = null;
            childIndex++;
          }
        }

        return {
          done: true
        };
      }
    };
  }

  /**
   * Universal Router (https://www.kriasoft.com/universal-router/)
   *
   * Copyright (c) 2015-present Kriasoft.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.txt file in the root directory of this source tree.
   */

  function resolveRoute(context) {
    if (isFunction(context.route.action)) {
      return context.route.action(context);
    }

    return undefined;
  }

  function isChildRoute(parentRoute, childRoute) {
    var route = childRoute;

    while (route) {
      route = route.parent;

      if (route === parentRoute) {
        return true;
      }
    }

    return false;
  }

  function generateErrorMessage(currentContext) {
    var errorMessage = "Path '".concat(currentContext.pathname, "' is not properly resolved due to an error.");
    var routePath = (currentContext.route || {}).path;

    if (routePath) {
      errorMessage += " Resolution had failed on route: '".concat(routePath, "'");
    }

    return errorMessage;
  }

  function updateChainForRoute(context, match) {
    var route = match.route,
        path = match.path;

    if (route && !route.__synthetic) {
      var item = {
        path: path,
        route: route
      };

      if (!context.chain) {
        context.chain = [];
      } else {
        // Discard old items
        if (route.parent) {
          var i = context.chain.length;

          while (i-- && context.chain[i].route && context.chain[i].route !== route.parent) {
            context.chain.pop();
          }
        }
      }

      context.chain.push(item);
    }
  }
  /**
   */


  var Resolver = /*#__PURE__*/function () {
    function Resolver(routes) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      _classCallCheck(this, Resolver);

      if (Object(routes) !== routes) {
        throw new TypeError('Invalid routes');
      }

      this.baseUrl = options.baseUrl || '';
      this.errorHandler = options.errorHandler;
      this.resolveRoute = options.resolveRoute || resolveRoute;
      this.context = Object.assign({
        resolver: this
      }, options.context);
      this.root = Array.isArray(routes) ? {
        path: '',
        __children: routes,
        parent: null,
        __synthetic: true
      } : routes;
      this.root.parent = null;
    }
    /**
     * Returns the current list of routes (as a shallow copy). Adding / removing
     * routes to / from the returned array does not affect the routing config,
     * but modifying the route objects does.
     *
     * @return {!Array<!Router.Route>}
     */


    _createClass(Resolver, [{
      key: "getRoutes",
      value: function getRoutes() {
        return _toConsumableArray(this.root.__children);
      }
      /**
       * Sets the routing config (replacing the existing one).
       *
       * @param {!Array<!Router.Route>|!Router.Route} routes a single route or an array of those
       *    (the array is shallow copied)
       */

    }, {
      key: "setRoutes",
      value: function setRoutes(routes) {
        ensureRoutes(routes);

        var newRoutes = _toConsumableArray(toArray(routes));

        this.root.__children = newRoutes;
      }
      /**
       * Appends one or several routes to the routing config and returns the
       * effective routing config after the operation.
       *
       * @param {!Array<!Router.Route>|!Router.Route} routes a single route or an array of those
       *    (the array is shallow copied)
       * @return {!Array<!Router.Route>}
       * @protected
       */

    }, {
      key: "addRoutes",
      value: function addRoutes(routes) {
        var _this$root$__children;

        ensureRoutes(routes);

        (_this$root$__children = this.root.__children).push.apply(_this$root$__children, _toConsumableArray(toArray(routes)));

        return this.getRoutes();
      }
      /**
       * Removes all existing routes from the routing config.
       */

    }, {
      key: "removeRoutes",
      value: function removeRoutes() {
        this.setRoutes([]);
      }
      /**
       * Asynchronously resolves the given pathname, i.e. finds all routes matching
       * the pathname and tries resolving them one after another in the order they
       * are listed in the routes config until the first non-null result.
       *
       * Returns a promise that is fulfilled with the return value of an object that consists of the first
       * route handler result that returns something other than `null` or `undefined` and context used to get this result.
       *
       * If no route handlers return a non-null result, or if no route matches the
       * given pathname the returned promise is rejected with a 'page not found'
       * `Error`.
       *
       * @param {!string|!{pathname: !string}} pathnameOrContext the pathname to
       *    resolve or a context object with a `pathname` property and other
       *    properties to pass to the route resolver functions.
       * @return {!Promise<any>}
       */

    }, {
      key: "resolve",
      value: function resolve(pathnameOrContext) {
        var _this = this;

        var context = Object.assign({}, this.context, isString(pathnameOrContext) ? {
          pathname: pathnameOrContext
        } : pathnameOrContext);
        var match = matchRoute(this.root, this.__normalizePathname(context.pathname), this.baseUrl);
        var resolve = this.resolveRoute;
        var matches = null;
        var nextMatches = null;
        var currentContext = context;

        function next(resume) {
          var parent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : matches.value.route;
          var prevResult = arguments.length > 2 ? arguments[2] : undefined;
          var routeToSkip = prevResult === null && matches.value.route;
          matches = nextMatches || match.next(routeToSkip);
          nextMatches = null;

          if (!resume) {
            if (matches.done || !isChildRoute(parent, matches.value.route)) {
              nextMatches = matches;
              return Promise.resolve(notFoundResult);
            }
          }

          if (matches.done) {
            return Promise.reject(getNotFoundError(context));
          }

          currentContext = Object.assign(currentContext ? {
            chain: currentContext.chain ? currentContext.chain.slice(0) : []
          } : {}, context, matches.value);
          updateChainForRoute(currentContext, matches.value);
          return Promise.resolve(resolve(currentContext)).then(function (resolution) {
            if (resolution !== null && resolution !== undefined && resolution !== notFoundResult) {
              currentContext.result = resolution.result || resolution;
              return currentContext;
            }

            return next(resume, parent, resolution);
          });
        }

        context.next = next;
        return Promise.resolve().then(function () {
          return next(true, _this.root);
        }).catch(function (error) {
          var errorMessage = generateErrorMessage(currentContext);

          if (!error) {
            error = new Error(errorMessage);
          } else {
            console.warn(errorMessage);
          }

          error.context = error.context || currentContext; // DOMException has its own code which is read-only

          if (!(error instanceof DOMException)) {
            error.code = error.code || 500;
          }

          if (_this.errorHandler) {
            currentContext.result = _this.errorHandler(error);
            return currentContext;
          }

          throw error;
        });
      }
      /**
       * URL constructor polyfill hook. Creates and returns an URL instance.
       */

    }, {
      key: "__normalizePathname",

      /**
       * If the baseUrl is set, matches the pathname with the router’s baseUrl,
       * and returns the local pathname with the baseUrl stripped out.
       *
       * If the pathname does not match the baseUrl, returns undefined.
       *
       * If the `baseUrl` is not set, returns the unmodified pathname argument.
       */
      value: function __normalizePathname(pathname) {
        if (!this.baseUrl) {
          // No base URL, no need to transform the pathname.
          return pathname;
        }

        var base = this.__effectiveBaseUrl;

        var normalizedUrl = this.constructor.__createUrl(pathname, base).href;

        if (normalizedUrl.slice(0, base.length) === base) {
          return normalizedUrl.slice(base.length);
        }
      }
    }, {
      key: "__effectiveBaseUrl",

      /**
       * If the baseUrl property is set, transforms the baseUrl and returns the full
       * actual `base` string for using in the `new URL(path, base);` and for
       * prepernding the paths with. The returned base ends with a trailing slash.
       *
       * Otherwise, returns empty string.
       */
      get: function get() {
        return this.baseUrl ? this.constructor.__createUrl(this.baseUrl, document.baseURI || document.URL).href.replace(/[^\/]*$/, '') : '';
      }
    }], [{
      key: "__createUrl",
      value: function __createUrl(url, base) {
        return new URL(url, base);
      }
    }]);

    return Resolver;
  }();

  Resolver.pathToRegexp = pathToRegexp_1;

  /**
   * Universal Router (https://www.kriasoft.com/universal-router/)
   *
   * Copyright (c) 2015-present Kriasoft.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.txt file in the root directory of this source tree.
   */
  var pathToRegexp$1 = Resolver.pathToRegexp;
  var cache$1 = new Map();

  function cacheRoutes(routesByName, route, routes) {
    var name = route.name || route.component;

    if (name) {
      if (routesByName.has(name)) {
        routesByName.get(name).push(route);
      } else {
        routesByName.set(name, [route]);
      }
    }

    if (Array.isArray(routes)) {
      for (var i = 0; i < routes.length; i++) {
        var childRoute = routes[i];
        childRoute.parent = route;
        cacheRoutes(routesByName, childRoute, childRoute.__children || childRoute.children);
      }
    }
  }

  function getRouteByName(routesByName, routeName) {
    var routes = routesByName.get(routeName);

    if (routes && routes.length > 1) {
      throw new Error("Duplicate route with name \"".concat(routeName, "\".") + " Try seting unique 'name' route properties.");
    }

    return routes && routes[0];
  }

  function getRoutePath(route) {
    var path = route.path;
    path = Array.isArray(path) ? path[0] : path;
    return path !== undefined ? path : '';
  }

  function generateUrls(router) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!(router instanceof Resolver)) {
      throw new TypeError('An instance of Resolver is expected');
    }

    var routesByName = new Map();
    return function (routeName, params) {
      var route = getRouteByName(routesByName, routeName);

      if (!route) {
        routesByName.clear(); // clear cache

        cacheRoutes(routesByName, router.root, router.root.__children);
        route = getRouteByName(routesByName, routeName);

        if (!route) {
          throw new Error("Route \"".concat(routeName, "\" not found"));
        }
      }

      var regexp = cache$1.get(route.fullPath);

      if (!regexp) {
        var fullPath = getRoutePath(route);
        var rt = route.parent;

        while (rt) {
          var path = getRoutePath(rt);

          if (path) {
            fullPath = path.replace(/\/$/, '') + '/' + fullPath.replace(/^\//, '');
          }

          rt = rt.parent;
        }

        var tokens = pathToRegexp$1.parse(fullPath);
        var toPath = pathToRegexp$1.tokensToFunction(tokens);
        var keys = Object.create(null);

        for (var i = 0; i < tokens.length; i++) {
          if (!isString(tokens[i])) {
            keys[tokens[i].name] = true;
          }
        }

        regexp = {
          toPath: toPath,
          keys: keys
        };
        cache$1.set(fullPath, regexp);
        route.fullPath = fullPath;
      }

      var url = regexp.toPath(params, options) || '/';

      if (options.stringifyQueryParams && params) {
        var queryParams = {};

        var _keys = Object.keys(params);

        for (var _i = 0; _i < _keys.length; _i++) {
          var key = _keys[_i];

          if (!regexp.keys[key]) {
            queryParams[key] = params[key];
          }
        }

        var query = options.stringifyQueryParams(queryParams);

        if (query) {
          url += query.charAt(0) === '?' ? query : "?".concat(query);
        }
      }

      return url;
    };
  }

  /**
   * @typedef NavigationTrigger
   * @type {object}
   * @property {function()} activate
   * @property {function()} inactivate
   */

  /** @type {Array<NavigationTrigger>} */
  var triggers = [];
  function setNavigationTriggers(newTriggers) {
    triggers.forEach(function (trigger) {
      return trigger.inactivate();
    });
    newTriggers.forEach(function (trigger) {
      return trigger.activate();
    });
    triggers = newTriggers;
  }

  var willAnimate = function willAnimate(elem) {
    var name = getComputedStyle(elem).getPropertyValue('animation-name');
    return name && name !== 'none';
  };

  var waitForAnimation = function waitForAnimation(elem, cb) {
    var listener = function listener() {
      elem.removeEventListener('animationend', listener);
      cb();
    };

    elem.addEventListener('animationend', listener);
  };

  function animate(elem, className) {
    elem.classList.add(className);
    return new Promise(function (resolve) {
      if (willAnimate(elem)) {
        var rect = elem.getBoundingClientRect();
        var size = "height: ".concat(rect.bottom - rect.top, "px; width: ").concat(rect.right - rect.left, "px");
        elem.setAttribute('style', "position: absolute; ".concat(size));
        waitForAnimation(elem, function () {
          elem.classList.remove(className);
          elem.removeAttribute('style');
          resolve();
        });
      } else {
        elem.classList.remove(className);
        resolve();
      }
    });
  }

  var MAX_REDIRECT_COUNT = 256;

  function isResultNotEmpty(result) {
    return result !== null && result !== undefined;
  }

  function copyContextWithoutNext(context) {
    var copy = Object.assign({}, context);
    delete copy.next;
    return copy;
  }

  function createLocation(_ref, route) {
    var _ref$pathname = _ref.pathname,
        pathname = _ref$pathname === void 0 ? '' : _ref$pathname,
        _ref$search = _ref.search,
        search = _ref$search === void 0 ? '' : _ref$search,
        _ref$hash = _ref.hash,
        hash = _ref$hash === void 0 ? '' : _ref$hash,
        _ref$chain = _ref.chain,
        chain = _ref$chain === void 0 ? [] : _ref$chain,
        _ref$params = _ref.params,
        params = _ref$params === void 0 ? {} : _ref$params,
        redirectFrom = _ref.redirectFrom,
        resolver = _ref.resolver;
    var routes = chain.map(function (item) {
      return item.route;
    });
    return {
      baseUrl: resolver && resolver.baseUrl || '',
      pathname: pathname,
      search: search,
      hash: hash,
      routes: routes,
      route: route || routes.length && routes[routes.length - 1] || null,
      params: params,
      redirectFrom: redirectFrom,
      getUrl: function getUrl() {
        var userParams = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return getPathnameForRouter(Router.pathToRegexp.compile(getMatchedPath(routes))(Object.assign({}, params, userParams)), resolver);
      }
    };
  }

  function createRedirect(context, pathname) {
    var params = Object.assign({}, context.params);
    return {
      redirect: {
        pathname: pathname,
        from: context.pathname,
        params: params
      }
    };
  }

  function renderElement(context, element) {
    element.location = createLocation(context);
    var index = context.chain.map(function (item) {
      return item.route;
    }).indexOf(context.route);
    context.chain[index].element = element;
    return element;
  }

  function runCallbackIfPossible(callback, args, thisArg) {
    if (isFunction(callback)) {
      return callback.apply(thisArg, args);
    }
  }

  function amend(amendmentFunction, args, element) {
    return function (amendmentResult) {
      if (amendmentResult && (amendmentResult.cancel || amendmentResult.redirect)) {
        return amendmentResult;
      }

      if (element) {
        return runCallbackIfPossible(element[amendmentFunction], args, element);
      }
    };
  }

  function processNewChildren(newChildren, route) {
    if (!Array.isArray(newChildren) && !isObject(newChildren)) {
      throw new Error(log("Incorrect \"children\" value for the route ".concat(route.path, ": expected array or object, but got ").concat(newChildren)));
    }

    route.__children = [];
    var childRoutes = toArray(newChildren);

    for (var i = 0; i < childRoutes.length; i++) {
      ensureRoute(childRoutes[i]);

      route.__children.push(childRoutes[i]);
    }
  }

  function removeDomNodes(nodes) {
    if (nodes && nodes.length) {
      var parent = nodes[0].parentNode;

      for (var i = 0; i < nodes.length; i++) {
        parent.removeChild(nodes[i]);
      }
    }
  }

  function getPathnameForRouter(pathname, router) {
    var base = router.__effectiveBaseUrl;
    return base ? router.constructor.__createUrl(pathname.replace(/^\//, ''), base).pathname : pathname;
  }

  function getMatchedPath(chain) {
    return chain.map(function (item) {
      return item.path;
    }).reduce(function (a, b) {
      if (b.length) {
        return a.replace(/\/$/, '') + '/' + b.replace(/^\//, '');
      }

      return a;
    }, '');
  }
  /**
   * A simple client-side router for single-page applications. It uses
   * express-style middleware and has a first-class support for Web Components and
   * lazy-loading. Works great in Polymer and non-Polymer apps.
   *
   * Use `new Router(outlet, options)` to create a new Router instance.
   *
   * * The `outlet` parameter is a reference to the DOM node to render
   *   the content into.
   *
   * * The `options` parameter is an optional object with options. The following
   *   keys are supported:
   *   * `baseUrl` — the initial value for [
   *     the `baseUrl` property
   *   ](#/classes/Router#property-baseUrl)
   *
   * The Router instance is automatically subscribed to navigation events
   * on `window`.
   *
   * See [Live Examples](#/classes/Router/demos/demo/index.html) for the detailed usage demo and code snippets.
   *
   * See also detailed API docs for the following methods, for the advanced usage:
   *
   * * [setOutlet](#/classes/Router#method-setOutlet) – should be used to configure the outlet.
   * * [setTriggers](#/classes/Router#method-setTriggers) – should be used to configure the navigation events.
   * * [setRoutes](#/classes/Router#method-setRoutes) – should be used to configure the routes.
   *
   * Only `setRoutes` has to be called manually, others are automatically invoked when creating a new instance.
   *
   * @extends Resolver
   * @demo demo/index.html
   * @summary JavaScript class that renders different DOM content depending on
   *    a given path. It can re-render when triggered or automatically on
   *    'popstate' and / or 'click' events.
   */


  var Router = /*#__PURE__*/function (_Resolver) {
    _inherits(Router, _Resolver);

    var _super = _createSuper(Router);

    /**
     * Creates a new Router instance with a given outlet, and
     * automatically subscribes it to navigation events on the `window`.
     * Using a constructor argument or a setter for outlet is equivalent:
     *
     * ```
     * const router = new Router();
     * router.setOutlet(outlet);
     * ```
     * @param {?Node=} outlet
     * @param {?RouterOptions=} options
     */
    function Router(outlet, options) {
      var _this;

      _classCallCheck(this, Router);

      var baseElement = document.head.querySelector('base');
      var baseHref = baseElement && baseElement.getAttribute('href');
      _this = _super.call(this, [], Object.assign({
        // Default options
        baseUrl: baseHref && Resolver.__createUrl(baseHref, document.URL).pathname.replace(/[^\/]*$/, '')
      }, options));

      _this.resolveRoute = function (context) {
        return _this.__resolveRoute(context);
      };

      var triggers = Router.NavigationTrigger;
      Router.setTriggers.apply(Router, Object.keys(triggers).map(function (key) {
        return triggers[key];
      }));
      /**
       * The base URL for all routes in the router instance. By default,
       * if the base element exists in the `<head>`, vaadin-router
       * takes the `<base href>` attribute value, resolves against current `document.URL`
       * and gets the `pathname` from the result.
       *
       * @public
       * @type {string}
       */

      _this.baseUrl;
      /**
       * A promise that is settled after the current render cycle completes. If
       * there is no render cycle in progress the promise is immediately settled
       * with the last render cycle result.
       *
       * @public
       * @type {!Promise<!RouterLocation>}
       */

      _this.ready;
      _this.ready = Promise.resolve(outlet);
      /**
       * Contains read-only information about the current router location:
       * pathname, active routes, parameters. See the
       * [Location type declaration](#/classes/RouterLocation)
       * for more details.
       *
       * @public
       * @type {!RouterLocation}
       */

      _this.location;
      _this.location = createLocation({
        resolver: _assertThisInitialized(_this)
      });
      _this.__lastStartedRenderId = 0;
      _this.__navigationEventHandler = _this.__onNavigationEvent.bind(_assertThisInitialized(_this));

      _this.setOutlet(outlet);

      _this.subscribe(); // Using WeakMap instead of WeakSet because WeakSet is not supported by IE11


      _this.__createdByRouter = new WeakMap();
      _this.__addedByRouter = new WeakMap();
      return _this;
    }

    _createClass(Router, [{
      key: "__resolveRoute",
      value: function __resolveRoute(context) {
        var _this2 = this;

        var route = context.route;
        var callbacks = Promise.resolve();

        if (isFunction(route.children)) {
          callbacks = callbacks.then(function () {
            return route.children(copyContextWithoutNext(context));
          }).then(function (children) {
            // The route.children() callback might have re-written the
            // route.children property instead of returning a value
            if (!isResultNotEmpty(children) && !isFunction(route.children)) {
              children = route.children;
            }

            processNewChildren(children, route);
          });
        }

        var commands = {
          redirect: function redirect(path) {
            return createRedirect(context, path);
          },
          component: function component(_component) {
            var element = document.createElement(_component);

            _this2.__createdByRouter.set(element, true);

            return element;
          }
        };
        return callbacks.then(function () {
          if (_this2.__isLatestRender(context)) {
            return runCallbackIfPossible(route.action, [context, commands], route);
          }
        }).then(function (result) {
          if (isResultNotEmpty(result)) {
            // Actions like `() => import('my-view.js')` are not expected to
            // end the resolution, despite the result is not empty. Checking
            // the result with a whitelist of values that end the resolution.
            if (result instanceof HTMLElement || result.redirect || result === notFoundResult) {
              return result;
            }
          }

          if (isString(route.redirect)) {
            return commands.redirect(route.redirect);
          }

          if (route.bundle) {
            return loadBundle(route.bundle).then(function () {}, function () {
              throw new Error(log("Bundle not found: ".concat(route.bundle, ". Check if the file name is correct")));
            });
          }
        }).then(function (result) {
          if (isResultNotEmpty(result)) {
            return result;
          }

          if (isString(route.component)) {
            return commands.component(route.component);
          }
        });
      }
      /**
       * Sets the router outlet (the DOM node where the content for the current
       * route is inserted). Any content pre-existing in the router outlet is
       * removed at the end of each render pass.
       *
       * NOTE: this method is automatically invoked first time when creating a new Router instance.
       *
       * @param {?Node} outlet the DOM node where the content for the current route
       *     is inserted.
       */

    }, {
      key: "setOutlet",
      value: function setOutlet(outlet) {
        if (outlet) {
          this.__ensureOutlet(outlet);
        }

        this.__outlet = outlet;
      }
      /**
       * Returns the current router outlet. The initial value is `undefined`.
       *
       * @return {?Node} the current router outlet (or `undefined`)
       */

    }, {
      key: "getOutlet",
      value: function getOutlet() {
        return this.__outlet;
      }
      /**
       * Sets the routing config (replacing the existing one) and triggers a
       * navigation event so that the router outlet is refreshed according to the
       * current `window.location` and the new routing config.
       *
       * Each route object may have the following properties, listed here in the processing order:
       * * `path` – the route path (relative to the parent route if any) in the
       * [express.js syntax](https://expressjs.com/en/guide/routing.html#route-paths").
       *
       * * `children` – an array of nested routes or a function that provides this
       * array at the render time. The function can be synchronous or asynchronous:
       * in the latter case the render is delayed until the returned promise is
       * resolved. The `children` function is executed every time when this route is
       * being rendered. This allows for dynamic route structures (e.g. backend-defined),
       * but it might have a performance impact as well. In order to avoid calling
       * the function on subsequent renders, you can override the `children` property
       * of the route object and save the calculated array there
       * (via `context.route.children = [ route1, route2, ...];`).
       * Parent routes are fully resolved before resolving the children. Children
       * 'path' values are relative to the parent ones.
       *
       * * `action` – the action that is executed before the route is resolved.
       * The value for this property should be a function, accepting `context`
       * and `commands` parameters described below. If present, this function is
       * always invoked first, disregarding of the other properties' presence.
       * The action can return a result directly or within a `Promise`, which
       * resolves to the result. If the action result is an `HTMLElement` instance,
       * a `commands.component(name)` result, a `commands.redirect(path)` result,
       * or a `context.next()` result, the current route resolution is finished,
       * and other route config properties are ignored.
       * See also **Route Actions** section in [Live Examples](#/classes/Router/demos/demo/index.html).
       *
       * * `redirect` – other route's path to redirect to. Passes all route parameters to the redirect target.
       * The target route should also be defined.
       * See also **Redirects** section in [Live Examples](#/classes/Router/demos/demo/index.html).
       *
       * * `bundle` – string containing the path to `.js` or `.mjs` bundle to load before resolving the route,
       * or the object with "module" and "nomodule" keys referring to different bundles.
       * Each bundle is only loaded once. If "module" and "nomodule" are set, only one bundle is loaded,
       * depending on whether the browser supports ES modules or not.
       * The property is ignored when either an `action` returns the result or `redirect` property is present.
       * Any error, e.g. 404 while loading bundle will cause route resolution to throw.
       * See also **Code Splitting** section in [Live Examples](#/classes/Router/demos/demo/index.html).
       *
       * * `component` – the tag name of the Web Component to resolve the route to.
       * The property is ignored when either an `action` returns the result or `redirect` property is present.
       * If route contains the `component` property (or an action that return a component)
       * and its child route also contains the `component` property, child route's component
       * will be rendered as a light dom child of a parent component.
       *
       * * `name` – the string name of the route to use in the
       * [`router.urlForName(name, params)`](#/classes/Router#method-urlForName)
       * navigation helper method.
       *
       * For any route function (`action`, `children`) defined, the corresponding `route` object is available inside the callback
       * through the `this` reference. If you need to access it, make sure you define the callback as a non-arrow function
       * because arrow functions do not have their own `this` reference.
       *
       * `context` object that is passed to `action` function holds the following properties:
       * * `context.pathname` – string with the pathname being resolved
       *
       * * `context.search` – search query string
       *
       * * `context.hash` – hash string
       *
       * * `context.params` – object with route parameters
       *
       * * `context.route` – object that holds the route that is currently being rendered.
       *
       * * `context.next()` – function for asynchronously getting the next route
       * contents from the resolution chain (if any)
       *
       * `commands` object that is passed to `action` function has
       * the following methods:
       *
       * * `commands.redirect(path)` – function that creates a redirect data
       * for the path specified.
       *
       * * `commands.component(component)` – function that creates a new HTMLElement
       * with current context. Note: the component created by this function is reused if visiting the same path twice in row.
       *
       *
       * @param {!Array<!Route>|!Route} routes a single route or an array of those
       * @param {?boolean} skipRender configure the router but skip rendering the
       *     route corresponding to the current `window.location` values
       *
       * @return {!Promise<!Node>}
       */

    }, {
      key: "setRoutes",
      value: function setRoutes(routes) {
        var skipRender = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        this.__previousContext = undefined;
        this.__urlForName = undefined;

        _get(_getPrototypeOf(Router.prototype), "setRoutes", this).call(this, routes);

        if (!skipRender) {
          this.__onNavigationEvent();
        }

        return this.ready;
      }
      /**
       * Asynchronously resolves the given pathname and renders the resolved route
       * component into the router outlet. If no router outlet is set at the time of
       * calling this method, or at the time when the route resolution is completed,
       * a `TypeError` is thrown.
       *
       * Returns a promise that is fulfilled with the router outlet DOM Node after
       * the route component is created and inserted into the router outlet, or
       * rejected if no route matches the given path.
       *
       * If another render pass is started before the previous one is completed, the
       * result of the previous render pass is ignored.
       *
       * @param {!string|!{pathname: !string, search: ?string, hash: ?string}} pathnameOrContext
       *    the pathname to render or a context object with a `pathname` property,
       *    optional `search` and `hash` properties, and other properties
       *    to pass to the resolver.
       * @param {boolean=} shouldUpdateHistory
       *    update browser history with the rendered location
       * @return {!Promise<!Node>}
       */

    }, {
      key: "render",
      value: function render(pathnameOrContext, shouldUpdateHistory) {
        var _this3 = this;

        var renderId = ++this.__lastStartedRenderId;
        var context = Object.assign({
          search: '',
          hash: ''
        }, isString(pathnameOrContext) ? {
          pathname: pathnameOrContext
        } : pathnameOrContext, {
          __renderId: renderId
        }); // Find the first route that resolves to a non-empty result

        this.ready = this.resolve(context) // Process the result of this.resolve() and handle all special commands:
        // (redirect / prevent / component). If the result is a 'component',
        // then go deeper and build the entire chain of nested components matching
        // the pathname. Also call all 'on before' callbacks along the way.
        .then(function (context) {
          return _this3.__fullyResolveChain(context);
        }).then(function (context) {
          if (_this3.__isLatestRender(context)) {
            var previousContext = _this3.__previousContext; // Check if the render was prevented and make an early return in that case

            if (context === previousContext) {
              // Replace the history with the previous context
              // to make sure the URL stays the same.
              _this3.__updateBrowserHistory(previousContext, true);

              return _this3.location;
            }

            _this3.location = createLocation(context);

            if (shouldUpdateHistory) {
              // Replace only if first render redirects, so that we don’t leave
              // the redirecting record in the history
              _this3.__updateBrowserHistory(context, renderId === 1);
            }

            fireRouterEvent('location-changed', {
              router: _this3,
              location: _this3.location
            }); // Skip detaching/re-attaching there are no render changes

            if (context.__skipAttach) {
              _this3.__copyUnchangedElements(context, previousContext);

              _this3.__previousContext = context;
              return _this3.location;
            }

            _this3.__addAppearingContent(context, previousContext);

            var animationDone = _this3.__animateIfNeeded(context);

            _this3.__runOnAfterEnterCallbacks(context);

            _this3.__runOnAfterLeaveCallbacks(context, previousContext);

            return animationDone.then(function () {
              if (_this3.__isLatestRender(context)) {
                // If there is another render pass started after this one,
                // the 'disappearing content' would be removed when the other
                // render pass calls `this.__addAppearingContent()`
                _this3.__removeDisappearingContent();

                _this3.__previousContext = context;
                return _this3.location;
              }
            });
          }
        }).catch(function (error) {
          if (renderId === _this3.__lastStartedRenderId) {
            if (shouldUpdateHistory) {
              _this3.__updateBrowserHistory(context);
            }

            removeDomNodes(_this3.__outlet && _this3.__outlet.children);
            _this3.location = createLocation(Object.assign(context, {
              resolver: _this3
            }));
            fireRouterEvent('error', Object.assign({
              router: _this3,
              error: error
            }, context));
            throw error;
          }
        });
        return this.ready;
      } // `topOfTheChainContextBeforeRedirects` is a context coming from Resolver.resolve().
      // It would contain a 'redirect' route or the first 'component' route that
      // matched the pathname. There might be more child 'component' routes to be
      // resolved and added into the chain. This method would find and add them.
      // `contextBeforeRedirects` is the context containing such a child component
      // route. It's only necessary when this method is called recursively (otherwise
      // it's the same as the 'top of the chain' context).
      //
      // Apart from building the chain of child components, this method would also
      // handle 'redirect' routes, call 'onBefore' callbacks and handle 'prevent'
      // and 'redirect' callback results.

    }, {
      key: "__fullyResolveChain",
      value: function __fullyResolveChain(topOfTheChainContextBeforeRedirects) {
        var _this4 = this;

        var contextBeforeRedirects = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : topOfTheChainContextBeforeRedirects;
        return this.__findComponentContextAfterAllRedirects(contextBeforeRedirects) // `contextAfterRedirects` is always a context with an `HTMLElement` result
        // In other cases the promise gets rejected and .then() is not called
        .then(function (contextAfterRedirects) {
          var redirectsHappened = contextAfterRedirects !== contextBeforeRedirects;
          var topOfTheChainContextAfterRedirects = redirectsHappened ? contextAfterRedirects : topOfTheChainContextBeforeRedirects;
          var matchedPath = getPathnameForRouter(getMatchedPath(contextAfterRedirects.chain), contextAfterRedirects.resolver);
          var isFound = matchedPath === contextAfterRedirects.pathname; // Recursive method to try matching more child and sibling routes

          var findNextContextIfAny = function findNextContextIfAny(context) {
            var parent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : context.route;
            var prevResult = arguments.length > 2 ? arguments[2] : undefined;
            return context.next(undefined, parent, prevResult).then(function (nextContext) {
              if (nextContext === null || nextContext === notFoundResult) {
                // Next context is not found in children, ...
                if (isFound) {
                  // ...but original context is already fully matching - use it
                  return context;
                } else if (parent.parent !== null) {
                  // ...and there is no full match yet - step up to check siblings
                  return findNextContextIfAny(context, parent.parent, nextContext);
                } else {
                  return nextContext;
                }
              }

              return nextContext;
            });
          };

          return findNextContextIfAny(contextAfterRedirects).then(function (nextContext) {
            if (nextContext === null || nextContext === notFoundResult) {
              throw getNotFoundError(topOfTheChainContextAfterRedirects);
            }

            return nextContext && nextContext !== notFoundResult && nextContext !== contextAfterRedirects ? _this4.__fullyResolveChain(topOfTheChainContextAfterRedirects, nextContext) : _this4.__amendWithOnBeforeCallbacks(contextAfterRedirects);
          });
        });
      }
    }, {
      key: "__findComponentContextAfterAllRedirects",
      value: function __findComponentContextAfterAllRedirects(context) {
        var _this5 = this;

        var result = context.result;

        if (result instanceof HTMLElement) {
          renderElement(context, result);
          return Promise.resolve(context);
        } else if (result.redirect) {
          return this.__redirect(result.redirect, context.__redirectCount, context.__renderId).then(function (context) {
            return _this5.__findComponentContextAfterAllRedirects(context);
          });
        } else if (result instanceof Error) {
          return Promise.reject(result);
        } else {
          return Promise.reject(new Error(log("Invalid route resolution result for path \"".concat(context.pathname, "\". ") + "Expected redirect object or HTML element, but got: \"".concat(logValue(result), "\". ") + "Double check the action return value for the route.")));
        }
      }
    }, {
      key: "__amendWithOnBeforeCallbacks",
      value: function __amendWithOnBeforeCallbacks(contextWithFullChain) {
        var _this6 = this;

        return this.__runOnBeforeCallbacks(contextWithFullChain).then(function (amendedContext) {
          if (amendedContext === _this6.__previousContext || amendedContext === contextWithFullChain) {
            return amendedContext;
          }

          return _this6.__fullyResolveChain(amendedContext);
        });
      }
    }, {
      key: "__runOnBeforeCallbacks",
      value: function __runOnBeforeCallbacks(newContext) {
        var _this7 = this;

        var previousContext = this.__previousContext || {};
        var previousChain = previousContext.chain || [];
        var newChain = newContext.chain;
        var callbacks = Promise.resolve();

        var prevent = function prevent() {
          return {
            cancel: true
          };
        };

        var redirect = function redirect(pathname) {
          return createRedirect(newContext, pathname);
        };

        newContext.__divergedChainIndex = 0;
        newContext.__skipAttach = false;

        if (previousChain.length) {
          for (var i = 0; i < Math.min(previousChain.length, newChain.length); i = ++newContext.__divergedChainIndex) {
            if (previousChain[i].route !== newChain[i].route || previousChain[i].path !== newChain[i].path && previousChain[i].element !== newChain[i].element || !this.__isReusableElement(previousChain[i].element, newChain[i].element)) {
              break;
            }
          } // Skip re-attaching and notifications if element and chain do not change


          newContext.__skipAttach = // Same route chain
          newChain.length === previousChain.length && newContext.__divergedChainIndex == newChain.length && // Same element
          this.__isReusableElement(newContext.result, previousContext.result);

          if (newContext.__skipAttach) {
            // execute onBeforeLeave for changed segment element when skipping attach
            for (var _i = newChain.length - 1; _i >= 0; _i--) {
              callbacks = this.__runOnBeforeLeaveCallbacks(callbacks, newContext, {
                prevent: prevent
              }, previousChain[_i]);
            } // execute onBeforeEnter for changed segment element when skipping attach


            for (var _i2 = 0; _i2 < newChain.length; _i2++) {
              callbacks = this.__runOnBeforeEnterCallbacks(callbacks, newContext, {
                prevent: prevent,
                redirect: redirect
              }, newChain[_i2]);
              previousChain[_i2].element.location = createLocation(newContext, previousChain[_i2].route);
            }
          } else {
            // execute onBeforeLeave when NOT skipping attach
            for (var _i3 = previousChain.length - 1; _i3 >= newContext.__divergedChainIndex; _i3--) {
              callbacks = this.__runOnBeforeLeaveCallbacks(callbacks, newContext, {
                prevent: prevent
              }, previousChain[_i3]);
            }
          }
        } // execute onBeforeEnter when NOT skipping attach


        if (!newContext.__skipAttach) {
          for (var _i4 = 0; _i4 < newChain.length; _i4++) {
            if (_i4 < newContext.__divergedChainIndex) {
              if (_i4 < previousChain.length && previousChain[_i4].element) {
                previousChain[_i4].element.location = createLocation(newContext, previousChain[_i4].route);
              }
            } else {
              callbacks = this.__runOnBeforeEnterCallbacks(callbacks, newContext, {
                prevent: prevent,
                redirect: redirect
              }, newChain[_i4]);

              if (newChain[_i4].element) {
                newChain[_i4].element.location = createLocation(newContext, newChain[_i4].route);
              }
            }
          }
        }

        return callbacks.then(function (amendmentResult) {
          if (amendmentResult) {
            if (amendmentResult.cancel) {
              _this7.__previousContext.__renderId = newContext.__renderId;
              return _this7.__previousContext;
            }

            if (amendmentResult.redirect) {
              return _this7.__redirect(amendmentResult.redirect, newContext.__redirectCount, newContext.__renderId);
            }
          }

          return newContext;
        });
      }
    }, {
      key: "__runOnBeforeLeaveCallbacks",
      value: function __runOnBeforeLeaveCallbacks(callbacks, newContext, commands, chainElement) {
        var _this8 = this;

        var location = createLocation(newContext);
        return callbacks.then(function (result) {
          if (_this8.__isLatestRender(newContext)) {
            var afterLeaveFunction = amend('onBeforeLeave', [location, commands, _this8], chainElement.element);
            return afterLeaveFunction(result);
          }
        }).then(function (result) {
          if (!(result || {}).redirect) {
            return result;
          }
        });
      }
    }, {
      key: "__runOnBeforeEnterCallbacks",
      value: function __runOnBeforeEnterCallbacks(callbacks, newContext, commands, chainElement) {
        var _this9 = this;

        var location = createLocation(newContext, chainElement.route);
        return callbacks.then(function (result) {
          if (_this9.__isLatestRender(newContext)) {
            var beforeEnterFunction = amend('onBeforeEnter', [location, commands, _this9], chainElement.element);
            return beforeEnterFunction(result);
          }
        });
      }
    }, {
      key: "__isReusableElement",
      value: function __isReusableElement(element, otherElement) {
        if (element && otherElement) {
          return this.__createdByRouter.get(element) && this.__createdByRouter.get(otherElement) ? element.localName === otherElement.localName : element === otherElement;
        }

        return false;
      }
    }, {
      key: "__isLatestRender",
      value: function __isLatestRender(context) {
        return context.__renderId === this.__lastStartedRenderId;
      }
    }, {
      key: "__redirect",
      value: function __redirect(redirectData, counter, renderId) {
        if (counter > MAX_REDIRECT_COUNT) {
          throw new Error(log("Too many redirects when rendering ".concat(redirectData.from)));
        }

        return this.resolve({
          pathname: this.urlForPath(redirectData.pathname, redirectData.params),
          redirectFrom: redirectData.from,
          __redirectCount: (counter || 0) + 1,
          __renderId: renderId
        });
      }
    }, {
      key: "__ensureOutlet",
      value: function __ensureOutlet() {
        var outlet = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.__outlet;

        if (!(outlet instanceof Node)) {
          throw new TypeError(log("Expected router outlet to be a valid DOM Node (but got ".concat(outlet, ")")));
        }
      }
    }, {
      key: "__updateBrowserHistory",
      value: function __updateBrowserHistory(_ref2, replace) {
        var pathname = _ref2.pathname,
            _ref2$search = _ref2.search,
            search = _ref2$search === void 0 ? '' : _ref2$search,
            _ref2$hash = _ref2.hash,
            hash = _ref2$hash === void 0 ? '' : _ref2$hash;

        if (window.location.pathname !== pathname || window.location.search !== search || window.location.hash !== hash) {
          var changeState = replace ? 'replaceState' : 'pushState';
          window.history[changeState](null, document.title, pathname + search + hash);
          window.dispatchEvent(new PopStateEvent('popstate', {
            state: 'vaadin-router-ignore'
          }));
        }
      }
    }, {
      key: "__copyUnchangedElements",
      value: function __copyUnchangedElements(context, previousContext) {
        // Find the deepest common parent between the last and the new component
        // chains. Update references for the unchanged elements in the new chain
        var deepestCommonParent = this.__outlet;

        for (var i = 0; i < context.__divergedChainIndex; i++) {
          var unchangedElement = previousContext && previousContext.chain[i].element;

          if (unchangedElement) {
            if (unchangedElement.parentNode === deepestCommonParent) {
              context.chain[i].element = unchangedElement;
              deepestCommonParent = unchangedElement;
            } else {
              break;
            }
          }
        }

        return deepestCommonParent;
      }
    }, {
      key: "__addAppearingContent",
      value: function __addAppearingContent(context, previousContext) {
        var _this10 = this;

        this.__ensureOutlet(); // If the previous 'entering' animation has not completed yet,
        // stop it and remove that content from the DOM before adding new one.


        this.__removeAppearingContent(); // Copy reusable elements from the previousContext to current


        var deepestCommonParent = this.__copyUnchangedElements(context, previousContext); // Keep two lists of DOM elements:
        //  - those that should be removed once the transition animation is over
        //  - and those that should remain


        this.__appearingContent = [];
        this.__disappearingContent = Array.from(deepestCommonParent.children).filter( // Only remove layout content that was added by router
        function (e) {
          return _this10.__addedByRouter.get(e) && // Do not remove the result element to avoid flickering
          e !== context.result;
        }); // Add new elements (starting after the deepest common parent) to the DOM.
        // That way only the components that are actually different between the two
        // locations are added to the DOM (and those that are common remain in the
        // DOM without first removing and then adding them again).

        var parentElement = deepestCommonParent;

        for (var i = context.__divergedChainIndex; i < context.chain.length; i++) {
          var elementToAdd = context.chain[i].element;

          if (elementToAdd) {
            parentElement.appendChild(elementToAdd);

            this.__addedByRouter.set(elementToAdd, true);

            if (parentElement === deepestCommonParent) {
              this.__appearingContent.push(elementToAdd);
            }

            parentElement = elementToAdd;
          }
        }
      }
    }, {
      key: "__removeDisappearingContent",
      value: function __removeDisappearingContent() {
        if (this.__disappearingContent) {
          removeDomNodes(this.__disappearingContent);
        }

        this.__disappearingContent = null;
        this.__appearingContent = null;
      }
    }, {
      key: "__removeAppearingContent",
      value: function __removeAppearingContent() {
        if (this.__disappearingContent && this.__appearingContent) {
          removeDomNodes(this.__appearingContent);
          this.__disappearingContent = null;
          this.__appearingContent = null;
        }
      }
    }, {
      key: "__runOnAfterLeaveCallbacks",
      value: function __runOnAfterLeaveCallbacks(currentContext, targetContext) {
        if (!targetContext) {
          return;
        } // REVERSE iteration: from Z to A


        for (var i = targetContext.chain.length - 1; i >= currentContext.__divergedChainIndex; i--) {
          if (!this.__isLatestRender(currentContext)) {
            break;
          }

          var currentComponent = targetContext.chain[i].element;

          if (!currentComponent) {
            continue;
          }

          try {
            var location = createLocation(currentContext);
            runCallbackIfPossible(currentComponent.onAfterLeave, [location, {}, targetContext.resolver], currentComponent);
          } finally {
            if (this.__disappearingContent.indexOf(currentComponent) > -1) {
              removeDomNodes(currentComponent.children);
            }
          }
        }
      }
    }, {
      key: "__runOnAfterEnterCallbacks",
      value: function __runOnAfterEnterCallbacks(currentContext) {
        // forward iteration: from A to Z
        for (var i = currentContext.__divergedChainIndex; i < currentContext.chain.length; i++) {
          if (!this.__isLatestRender(currentContext)) {
            break;
          }

          var currentComponent = currentContext.chain[i].element || {};
          var location = createLocation(currentContext, currentContext.chain[i].route);
          runCallbackIfPossible(currentComponent.onAfterEnter, [location, {}, currentContext.resolver], currentComponent);
        }
      }
    }, {
      key: "__animateIfNeeded",
      value: function __animateIfNeeded(context) {
        var from = (this.__disappearingContent || [])[0];
        var to = (this.__appearingContent || [])[0];
        var promises = [];
        var chain = context.chain;
        var config;

        for (var i = chain.length; i > 0; i--) {
          if (chain[i - 1].route.animate) {
            config = chain[i - 1].route.animate;
            break;
          }
        }

        if (from && to && config) {
          var leave = isObject(config) && config.leave || 'leaving';
          var enter = isObject(config) && config.enter || 'entering';
          promises.push(animate(from, leave));
          promises.push(animate(to, enter));
        }

        return Promise.all(promises).then(function () {
          return context;
        });
      }
      /**
       * Subscribes this instance to navigation events on the `window`.
       *
       * NOTE: beware of resource leaks. For as long as a router instance is
       * subscribed to navigation events, it won't be garbage collected.
       */

    }, {
      key: "subscribe",
      value: function subscribe() {
        window.addEventListener('vaadin-router-go', this.__navigationEventHandler);
      }
      /**
       * Removes the subscription to navigation events created in the `subscribe()`
       * method.
       */

    }, {
      key: "unsubscribe",
      value: function unsubscribe() {
        window.removeEventListener('vaadin-router-go', this.__navigationEventHandler);
      }
    }, {
      key: "__onNavigationEvent",
      value: function __onNavigationEvent(event) {
        var _ref3 = event ? event.detail : window.location,
            pathname = _ref3.pathname,
            search = _ref3.search,
            hash = _ref3.hash;

        if (isString(this.__normalizePathname(pathname))) {
          if (event && event.preventDefault) {
            event.preventDefault();
          }

          this.render({
            pathname: pathname,
            search: search,
            hash: hash
          }, true);
        }
      }
      /**
       * Configures what triggers Router navigation events:
       *  - `POPSTATE`: popstate events on the current `window`
       *  - `CLICK`: click events on `<a>` links leading to the current page
       *
       * This method is invoked with the pre-configured values when creating a new Router instance.
       * By default, both `POPSTATE` and `CLICK` are enabled. This setup is expected to cover most of the use cases.
       *
       * See the `router-config.js` for the default navigation triggers config. Based on it, you can
       * create the own one and only import the triggers you need, instead of pulling in all the code,
       * e.g. if you want to handle `click` differently.
       *
       * See also **Navigation Triggers** section in [Live Examples](#/classes/Router/demos/demo/index.html).
       *
       * @param {...NavigationTrigger} triggers
       */

    }, {
      key: "urlForName",

      /**
       * Generates a URL for the route with the given name, optionally performing
       * substitution of parameters.
       *
       * The route is searched in all the Router instances subscribed to
       * navigation events.
       *
       * **Note:** For child route names, only array children are considered.
       * It is not possible to generate URLs using a name for routes set with
       * a children function.
       *
       * @function urlForName
       * @param {!string} name the route name or the route’s `component` name.
       * @param {Params=} params Optional object with route path parameters.
       * Named parameters are passed by name (`params[name] = value`), unnamed
       * parameters are passed by index (`params[index] = value`).
       *
       * @return {string}
       */
      value: function urlForName(name, params) {
        if (!this.__urlForName) {
          this.__urlForName = generateUrls(this);
        }

        return getPathnameForRouter(this.__urlForName(name, params), this);
      }
      /**
       * Generates a URL for the given route path, optionally performing
       * substitution of parameters.
       *
       * @param {!string} path string route path declared in [express.js syntax](https://expressjs.com/en/guide/routing.html#route-paths").
       * @param {Params=} params Optional object with route path parameters.
       * Named parameters are passed by name (`params[name] = value`), unnamed
       * parameters are passed by index (`params[index] = value`).
       *
       * @return {string}
       */

    }, {
      key: "urlForPath",
      value: function urlForPath(path, params) {
        return getPathnameForRouter(Router.pathToRegexp.compile(path)(params), this);
      }
      /**
       * Triggers navigation to a new path. Returns a boolean without waiting until
       * the navigation is complete. Returns `true` if at least one `Router`
       * has handled the navigation (was subscribed and had `baseUrl` matching
       * the `path` argument), otherwise returns `false`.
       *
       * @param {!string|!{pathname: !string, search: (string|undefined), hash: (string|undefined)}} path
       *   a new in-app path string, or an URL-like object with `pathname`
       *   string property, and optional `search` and `hash` string properties.
       * @return {boolean}
       */

    }], [{
      key: "setTriggers",
      value: function setTriggers() {
        for (var _len = arguments.length, triggers = new Array(_len), _key = 0; _key < _len; _key++) {
          triggers[_key] = arguments[_key];
        }

        setNavigationTriggers(triggers);
      }
    }, {
      key: "go",
      value: function go(path) {
        var _ref4 = isString(path) ? this.__createUrl(path, 'http://a') // some base to omit origin
        : path,
            pathname = _ref4.pathname,
            search = _ref4.search,
            hash = _ref4.hash;

        return fireRouterEvent('go', {
          pathname: pathname,
          search: search,
          hash: hash
        });
      }
    }]);

    return Router;
  }(Resolver);

  var DEV_MODE_CODE_REGEXP = /\/\*\*\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i;
  var FlowClients = window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients;

  function isMinified() {
    function test() {
      /** vaadin-dev-mode:start
      return false;
      vaadin-dev-mode:end **/
      return true;
    }

    return uncommentAndRun(test);
  }

  function isDevelopmentMode() {
    try {
      if (isForcedDevelopmentMode()) {
        return true;
      }

      if (!isLocalhost()) {
        return false;
      }

      if (FlowClients) {
        return !isFlowProductionMode();
      }

      return !isMinified();
    } catch (e) {
      // Some error in this code, assume production so no further actions will be taken
      return false;
    }
  }

  function isForcedDevelopmentMode() {
    return localStorage.getItem("vaadin.developmentmode.force");
  }

  function isLocalhost() {
    return ["localhost", "127.0.0.1"].indexOf(window.location.hostname) >= 0;
  }

  function isFlowProductionMode() {
    if (FlowClients) {
      var productionModeApps = Object.keys(FlowClients).map(function (key) {
        return FlowClients[key];
      }).filter(function (client) {
        return client.productionMode;
      });

      if (productionModeApps.length > 0) {
        return true;
      }
    }

    return false;
  }

  function uncommentAndRun(callback, args) {
    if (typeof callback !== 'function') {
      return;
    }

    var match = DEV_MODE_CODE_REGEXP.exec(callback.toString());

    if (match) {
      try {
        // requires CSP: script-src 'unsafe-eval'
        callback = new Function(match[1]);
      } catch (e) {
        // eat the exception
        console.log('vaadin-development-mode-detector: uncommentAndRun() failed', e);
      }
    }

    return callback(args);
  } // A guard against polymer-modulizer removing the window.Vaadin
  // initialization above.


  window['Vaadin'] = window['Vaadin'] || {};
  /**
   * Inspects the source code of the given `callback` function for
   * specially-marked _commented_ code. If such commented code is found in the
   * callback source, uncomments and runs that code instead of the callback
   * itself. Otherwise runs the callback as is.
   *
   * The optional arguments are passed into the callback / uncommented code,
   * the result is returned.
   *
   * See the `isMinified()` function source code in this file for an example.
   *
   */

  var runIfDevelopmentMode = function runIfDevelopmentMode(callback, args) {
    if (window.Vaadin.developmentMode) {
      return uncommentAndRun(callback, args);
    }
  };

  if (window.Vaadin.developmentMode === undefined) {
    window.Vaadin.developmentMode = isDevelopmentMode();
  }

  /* This file is autogenerated from src/vaadin-usage-statistics.tpl.html */

  function maybeGatherAndSendStats() {
    /** vaadin-dev-mode:start
    (function () {
    'use strict';
    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
    } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
    var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
    };
    var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
     return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
    }();
    var getPolymerVersion = function getPolymerVersion() {
    return window.Polymer && window.Polymer.version;
    };
    var StatisticsGatherer = function () {
    function StatisticsGatherer(logger) {
      classCallCheck(this, StatisticsGatherer);
       this.now = new Date().getTime();
      this.logger = logger;
    }
     createClass(StatisticsGatherer, [{
      key: 'frameworkVersionDetectors',
      value: function frameworkVersionDetectors() {
        return {
          'Flow': function Flow() {
            if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {
              var flowVersions = Object.keys(window.Vaadin.Flow.clients).map(function (key) {
                return window.Vaadin.Flow.clients[key];
              }).filter(function (client) {
                return client.getVersionInfo;
              }).map(function (client) {
                return client.getVersionInfo().flow;
              });
              if (flowVersions.length > 0) {
                return flowVersions[0];
              }
            }
          },
          'Vaadin Framework': function VaadinFramework() {
            if (window.vaadin && window.vaadin.clients) {
              var frameworkVersions = Object.values(window.vaadin.clients).filter(function (client) {
                return client.getVersionInfo;
              }).map(function (client) {
                return client.getVersionInfo().vaadinVersion;
              });
              if (frameworkVersions.length > 0) {
                return frameworkVersions[0];
              }
            }
          },
          'AngularJs': function AngularJs() {
            if (window.angular && window.angular.version && window.angular.version) {
              return window.angular.version.full;
            }
          },
          'Angular': function Angular() {
            if (window.ng) {
              var tags = document.querySelectorAll("[ng-version]");
              if (tags.length > 0) {
                return tags[0].getAttribute("ng-version");
              }
              return "Unknown";
            }
          },
          'Backbone.js': function BackboneJs() {
            if (window.Backbone) {
              return window.Backbone.VERSION;
            }
          },
          'React': function React() {
            var reactSelector = '[data-reactroot], [data-reactid]';
            if (!!document.querySelector(reactSelector)) {
              // React does not publish the version by default
              return "unknown";
            }
          },
          'Ember': function Ember() {
            if (window.Em && window.Em.VERSION) {
              return window.Em.VERSION;
            } else if (window.Ember && window.Ember.VERSION) {
              return window.Ember.VERSION;
            }
          },
          'jQuery': function (_jQuery) {
            function jQuery() {
              return _jQuery.apply(this, arguments);
            }
             jQuery.toString = function () {
              return _jQuery.toString();
            };
             return jQuery;
          }(function () {
            if (typeof jQuery === 'function' && jQuery.prototype.jquery !== undefined) {
              return jQuery.prototype.jquery;
            }
          }),
          'Polymer': function Polymer() {
            var version = getPolymerVersion();
            if (version) {
              return version;
            }
          },
          'LitElement': function LitElement() {
            var version = window.litElementVersions && window.litElementVersions[0];
            if (version) {
              return version;
            }
          },
          'LitHtml': function LitHtml() {
            var version = window.litHtmlVersions && window.litHtmlVersions[0];
            if (version) {
              return version;
            }
          },
          'Vue.js': function VueJs() {
            if (window.Vue) {
              return window.Vue.version;
            }
          }
        };
      }
    }, {
      key: 'getUsedVaadinElements',
      value: function getUsedVaadinElements(elements) {
        var version = getPolymerVersion();
        var elementClasses = void 0;
        // NOTE: In case you edit the code here, YOU MUST UPDATE any statistics reporting code in Flow.
        // Check all locations calling the method getEntries() in
        // https://github.com/vaadin/flow/blob/master/flow-server/src/main/java/com/vaadin/flow/internal/UsageStatistics.java#L106
        // Currently it is only used by BootstrapHandler.
        if (version && version.indexOf('2') === 0) {
          // Polymer 2: components classes are stored in window.Vaadin
          elementClasses = Object.keys(window.Vaadin).map(function (c) {
            return window.Vaadin[c];
          }).filter(function (c) {
            return c.is;
          });
        } else {
          // Polymer 3: components classes are stored in window.Vaadin.registrations
          elementClasses = window.Vaadin.registrations || [];
        }
        elementClasses.forEach(function (klass) {
          var version = klass.version ? klass.version : "0.0.0";
          elements[klass.is] = { version: version };
        });
      }
    }, {
      key: 'getUsedVaadinThemes',
      value: function getUsedVaadinThemes(themes) {
        ['Lumo', 'Material'].forEach(function (themeName) {
          var theme;
          var version = getPolymerVersion();
          if (version && version.indexOf('2') === 0) {
            // Polymer 2: themes are stored in window.Vaadin
            theme = window.Vaadin[themeName];
          } else {
            // Polymer 3: themes are stored in custom element registry
            theme = customElements.get('vaadin-' + themeName.toLowerCase() + '-styles');
          }
          if (theme && theme.version) {
            themes[themeName] = { version: theme.version };
          }
        });
      }
    }, {
      key: 'getFrameworks',
      value: function getFrameworks(frameworks) {
        var detectors = this.frameworkVersionDetectors();
        Object.keys(detectors).forEach(function (framework) {
          var detector = detectors[framework];
          try {
            var version = detector();
            if (version) {
              frameworks[framework] = { version: version };
            }
          } catch (e) {}
        });
      }
    }, {
      key: 'gather',
      value: function gather(storage) {
        var storedStats = storage.read();
        var gatheredStats = {};
        var types = ["elements", "frameworks", "themes"];
         types.forEach(function (type) {
          gatheredStats[type] = {};
          if (!storedStats[type]) {
            storedStats[type] = {};
          }
        });
         var previousStats = JSON.stringify(storedStats);
         this.getUsedVaadinElements(gatheredStats.elements);
        this.getFrameworks(gatheredStats.frameworks);
        this.getUsedVaadinThemes(gatheredStats.themes);
         var now = this.now;
        types.forEach(function (type) {
          var keys = Object.keys(gatheredStats[type]);
          keys.forEach(function (key) {
            if (!storedStats[type][key] || _typeof(storedStats[type][key]) != _typeof({})) {
              storedStats[type][key] = { firstUsed: now };
            }
            // Discards any previously logged version number
            storedStats[type][key].version = gatheredStats[type][key].version;
            storedStats[type][key].lastUsed = now;
          });
        });
         var newStats = JSON.stringify(storedStats);
        storage.write(newStats);
        if (newStats != previousStats && Object.keys(storedStats).length > 0) {
          this.logger.debug("New stats: " + newStats);
        }
      }
    }]);
    return StatisticsGatherer;
    }();
    var StatisticsStorage = function () {
    function StatisticsStorage(key) {
      classCallCheck(this, StatisticsStorage);
       this.key = key;
    }
     createClass(StatisticsStorage, [{
      key: 'read',
      value: function read() {
        var localStorageStatsString = localStorage.getItem(this.key);
        try {
          return JSON.parse(localStorageStatsString ? localStorageStatsString : '{}');
        } catch (e) {
          return {};
        }
      }
    }, {
      key: 'write',
      value: function write(data) {
        localStorage.setItem(this.key, data);
      }
    }, {
      key: 'clear',
      value: function clear() {
        localStorage.removeItem(this.key);
      }
    }, {
      key: 'isEmpty',
      value: function isEmpty() {
        var storedStats = this.read();
        var empty = true;
        Object.keys(storedStats).forEach(function (key) {
          if (Object.keys(storedStats[key]).length > 0) {
            empty = false;
          }
        });
         return empty;
      }
    }]);
    return StatisticsStorage;
    }();
    var StatisticsSender = function () {
    function StatisticsSender(url, logger) {
      classCallCheck(this, StatisticsSender);
       this.url = url;
      this.logger = logger;
    }
     createClass(StatisticsSender, [{
      key: 'send',
      value: function send(data, errorHandler) {
        var logger = this.logger;
         if (navigator.onLine === false) {
          logger.debug("Offline, can't send");
          errorHandler();
          return;
        }
        logger.debug("Sending data to " + this.url);
         var req = new XMLHttpRequest();
        req.withCredentials = true;
        req.addEventListener("load", function () {
          // Stats sent, nothing more to do
          logger.debug("Response: " + req.responseText);
        });
        req.addEventListener("error", function () {
          logger.debug("Send failed");
          errorHandler();
        });
        req.addEventListener("abort", function () {
          logger.debug("Send aborted");
          errorHandler();
        });
        req.open("POST", this.url);
        req.setRequestHeader("Content-Type", "application/json");
        req.send(data);
      }
    }]);
    return StatisticsSender;
    }();
    var StatisticsLogger = function () {
    function StatisticsLogger(id) {
      classCallCheck(this, StatisticsLogger);
       this.id = id;
    }
     createClass(StatisticsLogger, [{
      key: '_isDebug',
      value: function _isDebug() {
        return localStorage.getItem("vaadin." + this.id + ".debug");
      }
    }, {
      key: 'debug',
      value: function debug(msg) {
        if (this._isDebug()) {
          console.info(this.id + ": " + msg);
        }
      }
    }]);
    return StatisticsLogger;
    }();
    var UsageStatistics = function () {
    function UsageStatistics() {
      classCallCheck(this, UsageStatistics);
       this.now = new Date();
      this.timeNow = this.now.getTime();
      this.gatherDelay = 10; // Delay between loading this file and gathering stats
      this.initialDelay = 24 * 60 * 60;
       this.logger = new StatisticsLogger("statistics");
      this.storage = new StatisticsStorage("vaadin.statistics.basket");
      this.gatherer = new StatisticsGatherer(this.logger);
      this.sender = new StatisticsSender("https://tools.vaadin.com/usage-stats/submit", this.logger);
    }
     createClass(UsageStatistics, [{
      key: 'maybeGatherAndSend',
      value: function maybeGatherAndSend() {
        var _this = this;
         if (localStorage.getItem(UsageStatistics.optOutKey)) {
          return;
        }
        this.gatherer.gather(this.storage);
        setTimeout(function () {
          _this.maybeSend();
        }, this.gatherDelay * 1000);
      }
    }, {
      key: 'lottery',
      value: function lottery() {
        return true;
      }
    }, {
      key: 'currentMonth',
      value: function currentMonth() {
        return this.now.getYear() * 12 + this.now.getMonth();
      }
    }, {
      key: 'maybeSend',
      value: function maybeSend() {
        var firstUse = Number(localStorage.getItem(UsageStatistics.firstUseKey));
        var monthProcessed = Number(localStorage.getItem(UsageStatistics.monthProcessedKey));
         if (!firstUse) {
          // Use a grace period to avoid interfering with tests, incognito mode etc
          firstUse = this.timeNow;
          localStorage.setItem(UsageStatistics.firstUseKey, firstUse);
        }
         if (this.timeNow < firstUse + this.initialDelay * 1000) {
          this.logger.debug("No statistics will be sent until the initial delay of " + this.initialDelay + "s has passed");
          return;
        }
        if (this.currentMonth() <= monthProcessed) {
          this.logger.debug("This month has already been processed");
          return;
        }
        localStorage.setItem(UsageStatistics.monthProcessedKey, this.currentMonth());
        // Use random sampling
        if (this.lottery()) {
          this.logger.debug("Congratulations, we have a winner!");
        } else {
          this.logger.debug("Sorry, no stats from you this time");
          return;
        }
         this.send();
      }
    }, {
      key: 'send',
      value: function send() {
        // Ensure we have the latest data
        this.gatherer.gather(this.storage);
         // Read, send and clean up
        var data = this.storage.read();
        data["firstUse"] = Number(localStorage.getItem(UsageStatistics.firstUseKey));
        data["usageStatisticsVersion"] = UsageStatistics.version;
        var info = 'This request contains usage statistics gathered from the application running in development mode. \n\nStatistics gathering is automatically disabled and excluded from production builds.\n\nFor details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.\n\n\n\n';
        var self = this;
        this.sender.send(info + JSON.stringify(data), function () {
          // Revert the 'month processed' flag
          localStorage.setItem(UsageStatistics.monthProcessedKey, self.currentMonth() - 1);
        });
      }
    }], [{
      key: 'version',
      get: function get$1() {
        return '2.1.0';
      }
    }, {
      key: 'firstUseKey',
      get: function get$1() {
        return 'vaadin.statistics.firstuse';
      }
    }, {
      key: 'monthProcessedKey',
      get: function get$1() {
        return 'vaadin.statistics.monthProcessed';
      }
    }, {
      key: 'optOutKey',
      get: function get$1() {
        return 'vaadin.statistics.optout';
      }
    }]);
    return UsageStatistics;
    }();
    try {
    window.Vaadin = window.Vaadin || {};
    window.Vaadin.usageStatsChecker = window.Vaadin.usageStatsChecker || new UsageStatistics();
    window.Vaadin.usageStatsChecker.maybeGatherAndSend();
    } catch (e) {
    // Intentionally ignored as this is not a problem in the app being developed
    }
    }());
     vaadin-dev-mode:end **/
  }

  var usageStatistics = function usageStatistics() {
    if (typeof runIfDevelopmentMode === 'function') {
      return runIfDevelopmentMode(maybeGatherAndSendStats);
    }
  };

  window.Vaadin = window.Vaadin || {};
  window.Vaadin.registrations = window.Vaadin.registrations || [];
  window.Vaadin.registrations.push({
    is: '@vaadin/router',
    version: '1.7.4'
  });
  usageStatistics();

  Router.NavigationTrigger = {
    POPSTATE: POPSTATE,
    CLICK: CLICK
  };

  var isUrlAvailable, urlDocument, urlBase, urlAnchor;

  Resolver.__ensureUrlAvailableOrPolyfilled = function () {
    if (isUrlAvailable === undefined) {
      try {
        var url = new URL('b', 'http://a');
        url.pathname = 'c';
        isUrlAvailable = url.href === 'http://a/c';
      } catch (e) {
        isUrlAvailable = false;
      }

      if (!isUrlAvailable) {
        // The URL constructor is not available in IE11. Polyfill it by creating
        // an HTMLAnchorElement in an in-memory HTML document.
        urlDocument = document.implementation.createHTMLDocument('url');
        urlBase = urlDocument.createElement('base');
        urlDocument.head.appendChild(urlBase);
        urlAnchor = urlDocument.createElement('a');

        if (!urlAnchor.origin) {
          // IE11: HTMLAnchorElement does not have the `origin` property
          Object.defineProperty(urlAnchor, 'origin', {
            get: function get() {
              // IE11: on HTTP and HTTPS the default port is not included into
              // window.location.origin, so won't include it here either.
              var protocol = urlAnchor.protocol;
              var port = urlAnchor.port;
              var defaultHttp = protocol === 'http:' && port === '80';
              var defaultHttps = protocol === 'https:' && port === '443';
              var host = defaultHttp || defaultHttps ? urlAnchor.hostname : urlAnchor.host;
              return "".concat(protocol, "//").concat(host);
            }
          }); // IE11: HTMLAnchorElement pathname does not start with a leading slash

          var getPathnameOrig = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(urlAnchor), 'pathname').get;
          Object.defineProperty(urlAnchor, 'pathname', {
            get: function get() {
              var pathname = getPathnameOrig.apply(urlAnchor);
              return pathname.charAt(0) !== '/' ? '/' + pathname : pathname;
            }
          });
        }
      }
    }
  };

  Resolver.__createUrl = function (path, base) {
    Resolver.__ensureUrlAvailableOrPolyfilled();

    if (isUrlAvailable) {
      return new URL(path, base);
    }

    urlBase.href = base;
    urlAnchor.href = path.replace(/ /g, '%20'); // IE11: only absolute href setting results in correct part properties
    // (`protocol`, `host`, `port`, and such), otherwise they are empty.

    urlAnchor.href = urlAnchor.href; // eslint-disable-line no-self-assign

    return urlAnchor;
  };

  exports.Resolver = Resolver;
  exports.Router = Router;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=vaadin-router.umd.js.map
