/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   src/vaadin-combo-box-mixin.js
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

import {timeOut} from '@polymer/polymer/lib/utils/async.js';

import {Debouncer} from '@polymer/polymer/lib/utils/debounce.js';

import {flush} from '@polymer/polymer/lib/utils/flush.js';

import {templatize} from '@polymer/polymer/lib/utils/templatize.js';

import {IronA11yAnnouncer} from '@polymer/iron-a11y-announcer/iron-a11y-announcer.js';

import {IronA11yKeysBehavior} from '@polymer/iron-a11y-keys-behavior/iron-a11y-keys-behavior.js';

import {FlattenedNodesObserver} from '@polymer/polymer/lib/utils/flattened-nodes-observer.js';

export {ComboBoxMixin};

declare function ComboBoxMixin<T extends new (...args: any[]) => {}>(base: T): T & ComboBoxMixinConstructor;

interface ComboBoxMixinConstructor {
  new(...args: any[]): ComboBoxMixin;
}

export {ComboBoxMixinConstructor};

interface ComboBoxMixin {
  readonly _propertyForValue: string;

  /**
   * True if the dropdown is open, false otherwise.
   */
  opened: boolean;

  /**
   * Set true to prevent the overlay from opening automatically.
   */
  autoOpenDisabled: boolean|null|undefined;

  /**
   * Set to true to disable this element.
   */
  disabled: boolean;

  /**
   * When present, it specifies that the element field is read-only.
   */
  readonly: boolean;

  /**
   * Custom function for rendering the content of every item.
   * Receives three arguments:
   *
   * - `root` The `<vaadin-combo-box-item>` internal container DOM element.
   * - `comboBox` The reference to the `<vaadin-combo-box>` element.
   * - `model` The object with the properties related with the rendered
   *   item, contains:
   *   - `model.index` The index of the rendered item.
   *   - `model.item` The item.
   */
  renderer: ComboBoxRenderer|null|undefined;

  /**
   * A full set of items to filter the visible options from.
   * The items can be of either `String` or `Object` type.
   */
  items: ComboBoxItem[]|undefined;

  /**
   * If `true`, the user can input a value that is not present in the items list.
   * `value` property will be set to the input value in this case.
   * Also, when `value` is set programmatically, the input value will be set
   * to reflect that value.
   */
  allowCustomValue: boolean;

  /**
   * A subset of items, filtered based on the user input. Filtered items
   * can be assigned directly to omit the internal filtering functionality.
   * The items can be of either `String` or `Object` type.
   */
  filteredItems: ComboBoxItem[]|undefined;

  /**
   * The `String` value for the selected item of the combo box. Provides
   * the value for `iron-form`.
   *
   * When there’s no item selected, the value is an empty string.
   *
   * Use `selectedItem` property to get the raw selected item from
   * the `items` array.
   */
  value: string;

  /**
   * When set to `true`, "loading" attribute is added to host and the overlay element.
   */
  loading: boolean;
  _focusedIndex: number;

  /**
   * Filtering string the user has typed into the input field.
   */
  filter: string;

  /**
   * The selected item from the `items` array.
   */
  selectedItem: ComboBoxItem|null|undefined;

  /**
   * Path for label of the item. If `items` is an array of objects, the
   * `itemLabelPath` is used to fetch the displayed string label for each
   * item.
   *
   * The item label is also used for matching items when processing user
   * input, i.e., for filtering and selecting items.
   *
   * When using item templates, the property is still needed because it is used
   * for filtering, and for displaying the selected item value in the input box.
   */
  itemLabelPath: string;

  /**
   * Path for the value of the item. If `items` is an array of objects, the
   * `itemValuePath:` is used to fetch the string value for the selected
   * item.
   *
   * The item value is used in the `value` property of the combo box,
   * to provide the form value.
   */
  itemValuePath: string;

  /**
   * Path for the id of the item. If `items` is an array of objects,
   * the `itemIdPath` is used to compare and identify the same item
   * in `selectedItem` and `filteredItems` (items given by the
   * `dataProvider` callback).
   */
  itemIdPath: string|null|undefined;

  /**
   * The name of this element.
   */
  name: string|null|undefined;

  /**
   * Set to true if the value is invalid.
   */
  invalid: boolean;
  _toggleElement: HTMLElement|undefined;
  _clearElement: HTMLElement|undefined;
  _inputElementValue: string|null|undefined;
  ready(): void;

  /**
   * Manually invoke existing renderer.
   */
  render(): void;

  /**
   * Opens the dropdown list.
   */
  open(): void;

  /**
   * Closes the dropdown list.
   */
  close(): void;
  _isEventKey(event: KeyboardEvent, key: string): boolean;
  _onEscape(e: KeyboardEvent): void;

  /**
   * Clears the current value.
   */
  _clear(): void;

  /**
   * Reverts back to original value.
   */
  cancel(): void;

  /**
   * Filtering and items handling
   */
  _inputValueChanged(e: Event): void;
  _revertInputValue(): void;

  /**
   * Returns true if `value` is valid, and sets the `invalid` flag appropriately.
   *
   * @returns True if the value is valid and sets the `invalid` flag appropriately
   */
  validate(): boolean;

  /**
   * Returns true if the current input value satisfies all constraints (if any)
   *
   * You can override the `checkValidity` method for custom validations.
   */
  checkValidity(): boolean|undefined;
  _ensureTemplatized(): void;
  _preventInputBlur(): void;
  _restoreInputBlur(): void;
  _stopPropagation(e: Event): void;
}

import {ComboBoxRenderer} from '../@types/interfaces';

import {ComboBoxItem} from '../@types/interfaces';
