/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
/** @private */
export const GridHelper = class VaadinGridHelper {

  /**
    * @param {Array<Object>} columns array of columns to be modified
    * @param {number} scope multiplier added to base order for each column
    * @param {number} baseOrder base number used for order
    */
  static _updateColumnOrders(columns, scope, baseOrder) {
    let c = 1;
    columns.forEach((column) => {
      // avoid multiples of 10 because they introduce and extra zero and
      // causes the underlying calculations for child order goes wrong
      if (c % 10 === 0) {
        c++;
      }
      column._order = baseOrder + c * scope;
      c++;
    });
  }
};
