/*!
 * Copyright (c) 2018 Chris O'Hara <cohara87@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.validator=t()}(this,function(){"use strict";function g(e){if(!("string"==typeof e||e instanceof String))throw new TypeError("This library (validator.js) validates strings only")}function o(e){return g(e),e=Date.parse(e),isNaN(e)?null:new Date(e)}function r(e){return g(e),parseFloat(e)}var a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function n(e){return"object"===(void 0===e?"undefined":a(e))&&null!==e?e="function"==typeof e.toString?e.toString():"[object Object]":(null==e||isNaN(e)&&!e.length)&&(e=""),String(e)}function A(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},t=arguments[1];for(var r in t)void 0===e[r]&&(e[r]=t[r]);return e}function h(e,t){g(e);var r=void 0,i=void 0;i="object"===(void 0===t?"undefined":a(t))?(r=t.min||0,t.max):(r=t,arguments[2]);var o=encodeURI(e).split(/%..|./).length-1;return r<=o&&(void 0===i||o<=i)}var l={require_tld:!0,allow_underscores:!1,allow_trailing_dot:!1};function v(e,t){g(e),(t=A(t,l)).allow_trailing_dot&&"."===e[e.length-1]&&(e=e.substring(0,e.length-1));for(var r=e.split("."),i=0;i<r.length;i++)if(63<r[i].length)return!1;if(t.require_tld){var o=r.pop();if(!r.length||!/^([a-z\u00a1-\uffff]{2,}|xn[a-z0-9-]{2,})$/i.test(o))return!1;if(/[\s\u2002-\u200B\u202F\u205F\u3000\uFEFF\uDB40\uDC20]/.test(o))return!1}for(var n,a=0;a<r.length;a++){if(n=r[a],t.allow_underscores&&(n=n.replace(/_/g,"")),!/^[a-z\u00a1-\uffff0-9-]+$/i.test(n))return!1;if(/[\uff01-\uff5e]/.test(n))return!1;if("-"===n[0]||"-"===n[n.length-1])return!1}return!0}var s=/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/,u=/^[0-9A-F]{1,4}$/i;function m(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"";if(g(e),!(t=String(t)))return m(e,4)||m(e,6);if("4"===t)return!!s.test(e)&&e.split(".").sort(function(e,t){return e-t})[3]<=255;if("6"!==t)return!1;var r=e.split(":"),i=!1,o=m(r[r.length-1],4),n=o?7:8;if(r.length>n)return!1;if("::"===e)return!0;"::"===e.substr(0,2)?(r.shift(),r.shift(),i=!0):"::"===e.substr(e.length-2)&&(r.pop(),r.pop(),i=!0);for(var a=0;a<r.length;++a)if(""===r[a]&&0<a&&a<r.length-1){if(i)return!1;i=!0}else if(o&&a===r.length-1);else if(!u.test(r[a]))return!1;return i?1<=r.length:r.length===n}var $={allow_display_name:!1,require_display_name:!1,allow_utf8_local_part:!0,require_tld:!0},_=/^[a-z\d!#\$%&'\*\+\-\/=\?\^_`{\|}~\.\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+[a-z\d!#\$%&'\*\+\-\/=\?\^_`{\|}~\,\.\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF\s]*<(.+)>$/i,F=/^[a-z\d!#\$%&'\*\+\-\/=\?\^_`{\|}~]+$/i,S=/^[a-z\d]+$/,R=/^([\s\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e]|(\\[\x01-\x09\x0b\x0c\x0d-\x7f]))*$/i,E=/^[a-z\d!#\$%&'\*\+\-\/=\?\^_`{\|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+$/i,x=/^([\s\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|(\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*$/i;var c={protocols:["http","https","ftp"],require_tld:!0,require_protocol:!1,require_host:!0,require_valid_protocol:!0,allow_underscores:!1,allow_trailing_dot:!1,allow_protocol_relative_urls:!1},f=/^\[([^\]]+)\](?::([0-9]+))?$/;function p(e,t){for(var r=0;r<t.length;r++){var i=t[r];if(e===i||(o=i,"[object RegExp]"===Object.prototype.toString.call(o)&&i.test(e)))return!0}var o;return!1}var i=/^([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])$/,d=/^([0-9a-fA-F]){12}$/;var M=/^\d{1,2}$/;for(var e,C={"en-US":/^[A-Z]+$/i,"bg-BG":/^[А-Я]+$/i,"cs-CZ":/^[A-ZÁČĎÉĚÍŇÓŘŠŤÚŮÝŽ]+$/i,"da-DK":/^[A-ZÆØÅ]+$/i,"de-DE":/^[A-ZÄÖÜß]+$/i,"el-GR":/^[Α-ω]+$/i,"es-ES":/^[A-ZÁÉÍÑÓÚÜ]+$/i,"fr-FR":/^[A-ZÀÂÆÇÉÈÊËÏÎÔŒÙÛÜŸ]+$/i,"it-IT":/^[A-ZÀÉÈÌÎÓÒÙ]+$/i,"nb-NO":/^[A-ZÆØÅ]+$/i,"nl-NL":/^[A-ZÁÉËÏÓÖÜÚ]+$/i,"nn-NO":/^[A-ZÆØÅ]+$/i,"hu-HU":/^[A-ZÁÉÍÓÖŐÚÜŰ]+$/i,"pl-PL":/^[A-ZĄĆĘŚŁŃÓŻŹ]+$/i,"pt-PT":/^[A-ZÃÁÀÂÇÉÊÍÕÓÔÚÜ]+$/i,"ru-RU":/^[А-ЯЁ]+$/i,"sk-SK":/^[A-ZÁČĎÉÍŇÓŠŤÚÝŽĹŔĽÄÔ]+$/i,"sr-RS@latin":/^[A-ZČĆŽŠĐ]+$/i,"sr-RS":/^[А-ЯЂЈЉЊЋЏ]+$/i,"sv-SE":/^[A-ZÅÄÖ]+$/i,"tr-TR":/^[A-ZÇĞİıÖŞÜ]+$/i,"uk-UA":/^[А-ЩЬЮЯЄIЇҐі]+$/i,"ku-IQ":/^[ئابپتجچحخدرڕزژسشعغفڤقکگلڵمنوۆھەیێيطؤثآإأكضصةظذ]+$/i,ar:/^[ءآأؤإئابةتثجحخدذرزسشصضطظعغفقكلمنهوىيًٌٍَُِّْٰ]+$/},N={"en-US":/^[0-9A-Z]+$/i,"bg-BG":/^[0-9А-Я]+$/i,"cs-CZ":/^[0-9A-ZÁČĎÉĚÍŇÓŘŠŤÚŮÝŽ]+$/i,"da-DK":/^[0-9A-ZÆØÅ]+$/i,"de-DE":/^[0-9A-ZÄÖÜß]+$/i,"el-GR":/^[0-9Α-ω]+$/i,"es-ES":/^[0-9A-ZÁÉÍÑÓÚÜ]+$/i,"fr-FR":/^[0-9A-ZÀÂÆÇÉÈÊËÏÎÔŒÙÛÜŸ]+$/i,"it-IT":/^[0-9A-ZÀÉÈÌÎÓÒÙ]+$/i,"hu-HU":/^[0-9A-ZÁÉÍÓÖŐÚÜŰ]+$/i,"nb-NO":/^[0-9A-ZÆØÅ]+$/i,"nl-NL":/^[0-9A-ZÁÉËÏÓÖÜÚ]+$/i,"nn-NO":/^[0-9A-ZÆØÅ]+$/i,"pl-PL":/^[0-9A-ZĄĆĘŚŁŃÓŻŹ]+$/i,"pt-PT":/^[0-9A-ZÃÁÀÂÇÉÊÍÕÓÔÚÜ]+$/i,"ru-RU":/^[0-9А-ЯЁ]+$/i,"sk-SK":/^[0-9A-ZÁČĎÉÍŇÓŠŤÚÝŽĹŔĽÄÔ]+$/i,"sr-RS@latin":/^[0-9A-ZČĆŽŠĐ]+$/i,"sr-RS":/^[0-9А-ЯЂЈЉЊЋЏ]+$/i,"sv-SE":/^[0-9A-ZÅÄÖ]+$/i,"tr-TR":/^[0-9A-ZÇĞİıÖŞÜ]+$/i,"uk-UA":/^[0-9А-ЩЬЮЯЄIЇҐі]+$/i,"ku-IQ":/^[٠١٢٣٤٥٦٧٨٩0-9ئابپتجچحخدرڕزژسشعغفڤقکگلڵمنوۆھەیێيطؤثآإأكضصةظذ]+$/i,ar:/^[٠١٢٣٤٥٦٧٨٩0-9ءآأؤإئابةتثجحخدذرزسشصضطظعغفقكلمنهوىيًٌٍَُِّْٰ]+$/},w={"en-US":".",ar:"٫"},t=["AU","GB","HK","IN","NZ","ZA","ZM"],L=0;L<t.length;L++)C[e="en-"+t[L]]=C["en-US"],N[e]=N["en-US"],w[e]=w["en-US"];for(var I,T=["AE","BH","DZ","EG","IQ","JO","KW","LB","LY","MA","QM","QA","SA","SD","SY","TN","YE"],Z=0;Z<T.length;Z++)C[I="ar-"+T[Z]]=C.ar,N[I]=N.ar,w[I]=w.ar;for(var B=[],D=["bg-BG","cs-CZ","da-DK","de-DE","el-GR","es-ES","fr-FR","it-IT","ku-IQ","hu-HU","nb-NO","nn-NO","nl-NL","pl-PL","pt-PT","ru-RU","sr-RS@latin","sr-RS","sv-SE","tr-TR","uk-UA"],y=0;y<B.length;y++)w[B[y]]=w["en-US"];for(var G=0;G<D.length;G++)w[D[G]]=",";C["pt-BR"]=C["pt-PT"],N["pt-BR"]=N["pt-PT"],w["pt-BR"]=w["pt-PT"],C["pl-Pl"]=C["pl-PL"],N["pl-Pl"]=N["pl-PL"],w["pl-Pl"]=w["pl-PL"];var O=/^[+-]?([0-9]*[.])?[0-9]+$/,b=/^[0-9]+$/;var P=/^(?:[-+]?(?:0|[1-9][0-9]*))$/,U=/^[-+]?[0-9]+$/;function k(e,t){g(e);var r=(t=t||{}).hasOwnProperty("allow_leading_zeroes")&&!t.allow_leading_zeroes?P:U,i=!t.hasOwnProperty("min")||e>=t.min,o=!t.hasOwnProperty("max")||e<=t.max,n=!t.hasOwnProperty("lt")||e<t.lt,a=!t.hasOwnProperty("gt")||e>t.gt;return r.test(e)&&i&&o&&n&&a}var K=/^[\x00-\x7F]+$/;var H=/[^\u0020-\u007E\uFF61-\uFF9F\uFFA0-\uFFDC\uFFE8-\uFFEE0-9a-zA-Z]/;var z=/[\u0020-\u007E\uFF61-\uFF9F\uFFA0-\uFFDC\uFFE8-\uFFEE0-9a-zA-Z]/;var W=/[^\x00-\x7F]/;var V=/[\uD800-\uDBFF][\uDC00-\uDFFF]/;var Y=function(e,t){return e.some(function(e){return t===e})};var j={force_decimal:!1,decimal_digits:"1,",locale:"en-US"},J=["","-","+"];var q=/^[0-9A-F]+$/i;function Q(e){return g(e),q.test(e)}var X=/^#?([0-9A-F]{3}|[0-9A-F]{6})$/i;var ee=/^[A-Z]{2}[0-9A-Z]{3}\d{2}\d{5}$/;var te=/^[a-f0-9]{32}$/;var re={md5:32,md4:32,sha1:40,sha256:64,sha384:96,sha512:128,ripemd128:32,ripemd160:40,tiger128:32,tiger160:40,tiger192:48,crc32:8,crc32b:8};var ie=/^[a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+$/;var oe={ignore_whitespace:!1};var ne={3:/^[0-9A-F]{8}-[0-9A-F]{4}-3[0-9A-F]{3}-[0-9A-F]{4}-[0-9A-F]{12}$/i,4:/^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i,5:/^[0-9A-F]{8}-[0-9A-F]{4}-5[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i,all:/^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i};var ae=/^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|(222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11}|6[27][0-9]{14})$/;var le=/^[A-Z]{2}[0-9A-Z]{9}[0-9]$/;var se=/^(?:[0-9]{9}X|[0-9]{10})$/,ue=/^(?:[0-9]{13})$/,de=[1,3];var ce={"ar-AE":/^((\+?971)|0)?5[024568]\d{7}$/,"ar-DZ":/^(\+?213|0)(5|6|7)\d{8}$/,"ar-EG":/^((\+?20)|0)?1[012]\d{8}$/,"ar-IQ":/^(\+?964|0)?7[0-9]\d{8}$/,"ar-JO":/^(\+?962|0)?7[789]\d{7}$/,"ar-KW":/^(\+?965)[569]\d{7}$/,"ar-SA":/^(!?(\+?966)|0)?5\d{8}$/,"ar-SY":/^(!?(\+?963)|0)?9\d{8}$/,"ar-TN":/^(\+?216)?[2459]\d{7}$/,"be-BY":/^(\+?375)?(24|25|29|33|44)\d{7}$/,"bg-BG":/^(\+?359|0)?8[789]\d{7}$/,"bn-BD":/\+?(88)?0?1[156789][0-9]{8}\b/,"cs-CZ":/^(\+?420)? ?[1-9][0-9]{2} ?[0-9]{3} ?[0-9]{3}$/,"da-DK":/^(\+?45)?\s?\d{2}\s?\d{2}\s?\d{2}\s?\d{2}$/,"de-DE":/^(\+?49[ \.\-]?)?([\(]{1}[0-9]{1,6}[\)])?([0-9 \.\-\/]{3,20})((x|ext|extension)[ ]?[0-9]{1,4})?$/,"el-GR":/^(\+?30|0)?(69\d{8})$/,"en-AU":/^(\+?61|0)4\d{8}$/,"en-GB":/^(\+?44|0)7\d{9}$/,"en-HK":/^(\+?852\-?)?[456789]\d{3}\-?\d{4}$/,"en-IN":/^(\+?91|0)?[6789]\d{9}$/,"en-KE":/^(\+?254|0)?[7]\d{8}$/,"en-NG":/^(\+?234|0)?[789]\d{9}$/,"en-NZ":/^(\+?64|0)[28]\d{7,9}$/,"en-PK":/^((\+92)|(0092))-{0,1}\d{3}-{0,1}\d{7}$|^\d{11}$|^\d{4}-\d{7}$/,"en-RW":/^(\+?250|0)?[7]\d{8}$/,"en-SG":/^(\+65)?[89]\d{7}$/,"en-TZ":/^(\+?255|0)?[67]\d{8}$/,"en-UG":/^(\+?256|0)?[7]\d{8}$/,"en-US":/^(\+?1?( |-)?)?(\([2-9][0-9]{2}\)|[2-9][0-9]{2})( |-)?([2-9][0-9]{2}( |-)?[0-9]{4})$/,"en-ZA":/^(\+?27|0)\d{9}$/,"en-ZM":/^(\+?26)?09[567]\d{7}$/,"es-ES":/^(\+?34)?(6\d{1}|7[1234])\d{7}$/,"es-MX":/^(\+?52)?(1|01)?\d{10,11}$/,"et-EE":/^(\+?372)?\s?(5|8[1-4])\s?([0-9]\s?){6,7}$/,"fa-IR":/^(\+?98[\-\s]?|0)9[0-39]\d[\-\s]?\d{3}[\-\s]?\d{4}$/,"fi-FI":/^(\+?358|0)\s?(4(0|1|2|4|5|6)?|50)\s?(\d\s?){4,8}\d$/,"fo-FO":/^(\+?298)?\s?\d{2}\s?\d{2}\s?\d{2}$/,"fr-FR":/^(\+?33|0)[67]\d{8}$/,"he-IL":/^(\+972|0)([23489]|5[012345689]|77)[1-9]\d{6}$/,"hu-HU":/^(\+?36)(20|30|70)\d{7}$/,"id-ID":/^(\+?62|0)(0?8?\d\d\s?\d?)([\s?|\d]{7,12})$/,"it-IT":/^(\+?39)?\s?3\d{2} ?\d{6,7}$/,"ja-JP":/^(\+?81|0)[789]0[ \-]?[1-9]\d{2}[ \-]?\d{5}$/,"kk-KZ":/^(\+?7|8)?7\d{9}$/,"kl-GL":/^(\+?299)?\s?\d{2}\s?\d{2}\s?\d{2}$/,"ko-KR":/^((\+?82)[ \-]?)?0?1([0|1|6|7|8|9]{1})[ \-]?\d{3,4}[ \-]?\d{4}$/,"lt-LT":/^(\+370|8)\d{8}$/,"ms-MY":/^(\+?6?01){1}(([145]{1}(\-|\s)?\d{7,8})|([236789]{1}(\s|\-)?\d{7}))$/,"nb-NO":/^(\+?47)?[49]\d{7}$/,"nl-BE":/^(\+?32|0)4?\d{8}$/,"nn-NO":/^(\+?47)?[49]\d{7}$/,"pl-PL":/^(\+?48)? ?[5-8]\d ?\d{3} ?\d{2} ?\d{2}$/,"pt-BR":/(?=^(\+?5{2}\-?|0)[1-9]{2}\-?\d{4}\-?\d{4}$)(^(\+?5{2}\-?|0)[1-9]{2}\-?[6-9]{1}\d{3}\-?\d{4}$)|(^(\+?5{2}\-?|0)[1-9]{2}\-?9[6-9]{1}\d{3}\-?\d{4}$)/,"pt-PT":/^(\+?351)?9[1236]\d{7}$/,"ro-RO":/^(\+?4?0)\s?7\d{2}(\/|\s|\.|\-)?\d{3}(\s|\.|\-)?\d{3}$/,"ru-RU":/^(\+?7|8)?9\d{9}$/,"sk-SK":/^(\+?421)? ?[1-9][0-9]{2} ?[0-9]{3} ?[0-9]{3}$/,"sr-RS":/^(\+3816|06)[- \d]{5,9}$/,"sv-SE":/^(\+?46|0)[\s\-]?7[\s\-]?[02369]([\s\-]?\d){7}$/,"th-TH":/^(\+66|66|0)\d{9}$/,"tr-TR":/^(\+?90|0)?5\d{9}$/,"uk-UA":/^(\+?38|8)?0\d{9}$/,"vi-VN":/^(\+?84|0)?((1(2([0-9])|6([2-9])|88|99))|(9((?!5)[0-9])))([0-9]{7})$/,"zh-CN":/^((\+|00)86)?1([358][0-9]|4[579]|66|7[0135678]|9[89])[0-9]{8}$/,"zh-TW":/^(\+?886\-?|0)?9\d{8}$/};ce["en-CA"]=ce["en-US"],ce["fr-BE"]=ce["nl-BE"],ce["zh-HK"]=ce["en-HK"];var fe={symbol:"$",require_symbol:!1,allow_space_after_symbol:!1,symbol_after_digits:!1,allow_negatives:!0,parens_for_negatives:!1,negative_sign_before_digits:!1,negative_sign_after_digits:!1,allow_negative_sign_placeholder:!1,thousands_separator:",",decimal_separator:".",allow_decimal:!0,require_decimal:!1,digits_after_decimal:[2],allow_space_after_digits:!1};var pe=/^([\+-]?\d{4}(?!\d{2}\b))((-?)((0[1-9]|1[0-2])(\3([12]\d|0[1-9]|3[01]))?|W([0-4]\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\d|[12]\d{2}|3([0-5]\d|6[1-6])))([T\s]((([01]\d|2[0-3])((:?)[0-5]\d)?|24:?00)([\.,]\d+(?!:))?)?(\17[0-5]\d([\.,]\d+)?)?([zZ]|([\+-])([01]\d|2[0-3]):?([0-5]\d)?)?)?)?$/;var ge=/([01][0-9]|2[0-3])/,Ae=/[0-5][0-9]/,he=new RegExp("[-+]"+ge.source+":"+Ae.source),ve=new RegExp("([zZ]|"+he.source+")"),me=new RegExp(ge.source+":"+Ae.source+":"+/([0-5][0-9]|60)/.source+/(\.[0-9]+)?/.source),$e=new RegExp(/[0-9]{4}/.source+"-"+/(0[1-9]|1[0-2])/.source+"-"+/([12]\d|0[1-9]|3[01])/.source),_e=new RegExp(""+me.source+ve.source),Fe=new RegExp($e.source+"[ tT]"+_e.source);var Se=["AD","AE","AF","AG","AI","AL","AM","AO","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW"];var Re=["AFG","ALA","ALB","DZA","ASM","AND","AGO","AIA","ATA","ATG","ARG","ARM","ABW","AUS","AUT","AZE","BHS","BHR","BGD","BRB","BLR","BEL","BLZ","BEN","BMU","BTN","BOL","BES","BIH","BWA","BVT","BRA","IOT","BRN","BGR","BFA","BDI","KHM","CMR","CAN","CPV","CYM","CAF","TCD","CHL","CHN","CXR","CCK","COL","COM","COG","COD","COK","CRI","CIV","HRV","CUB","CUW","CYP","CZE","DNK","DJI","DMA","DOM","ECU","EGY","SLV","GNQ","ERI","EST","ETH","FLK","FRO","FJI","FIN","FRA","GUF","PYF","ATF","GAB","GMB","GEO","DEU","GHA","GIB","GRC","GRL","GRD","GLP","GUM","GTM","GGY","GIN","GNB","GUY","HTI","HMD","VAT","HND","HKG","HUN","ISL","IND","IDN","IRN","IRQ","IRL","IMN","ISR","ITA","JAM","JPN","JEY","JOR","KAZ","KEN","KIR","PRK","KOR","KWT","KGZ","LAO","LVA","LBN","LSO","LBR","LBY","LIE","LTU","LUX","MAC","MKD","MDG","MWI","MYS","MDV","MLI","MLT","MHL","MTQ","MRT","MUS","MYT","MEX","FSM","MDA","MCO","MNG","MNE","MSR","MAR","MOZ","MMR","NAM","NRU","NPL","NLD","NCL","NZL","NIC","NER","NGA","NIU","NFK","MNP","NOR","OMN","PAK","PLW","PSE","PAN","PNG","PRY","PER","PHL","PCN","POL","PRT","PRI","QAT","REU","ROU","RUS","RWA","BLM","SHN","KNA","LCA","MAF","SPM","VCT","WSM","SMR","STP","SAU","SEN","SRB","SYC","SLE","SGP","SXM","SVK","SVN","SLB","SOM","ZAF","SGS","SSD","ESP","LKA","SDN","SUR","SJM","SWZ","SWE","CHE","SYR","TWN","TJK","TZA","THA","TLS","TGO","TKL","TON","TTO","TUN","TUR","TKM","TCA","TUV","UGA","UKR","ARE","GBR","USA","UMI","URY","UZB","VUT","VEN","VNM","VGB","VIR","WLF","ESH","YEM","ZMB","ZWE"];var Ee=/[^A-Z0-9+\/=]/i;var xe=/^[a-z]+\/[a-z0-9\-\+]+$/i,Me=/^[a-z\-]+=[a-z0-9\-]+$/i,Ce=/^[a-z0-9!\$&'\(\)\*\+,;=\-\._~:@\/\?%\s]*$/i;var Ne=/^magnet:\?xt=urn:[a-z0-9]+:[a-z0-9]{32,40}&dn=.+&tr=.+$/i;var we=/^(application|audio|font|image|message|model|multipart|text|video)\/[a-zA-Z0-9\.\-\+]{1,100}$/i,Le=/^text\/[a-zA-Z0-9\.\-\+]{1,100};\s?charset=("[a-zA-Z0-9\.\-\+\s]{0,70}"|[a-zA-Z0-9\.\-\+]{0,70})(\s?\([a-zA-Z0-9\.\-\+\s]{1,20}\))?$/i,Ie=/^multipart\/[a-zA-Z0-9\.\-\+]{1,100}(;\s?(boundary|charset)=("[a-zA-Z0-9\.\-\+\s]{0,70}"|[a-zA-Z0-9\.\-\+]{0,70})(\s?\([a-zA-Z0-9\.\-\+\s]{1,20}\))?){0,2}$/i;var Te=/^\(?[+-]?(90(\.0+)?|[1-8]?\d(\.\d+)?)$/,Ze=/^\s?[+-]?(180(\.0+)?|1[0-7]\d(\.\d+)?|\d{1,2}(\.\d+)?)\)?$/,Be=/^\d{4}$/,De=/^\d{5}$/,ye=/^\d{6}$/,Ge={AD:/^AD\d{3}$/,AT:Be,AU:Be,BE:Be,BG:Be,CA:/^[ABCEGHJKLMNPRSTVXY]\d[ABCEGHJ-NPRSTV-Z][\s\-]?\d[ABCEGHJ-NPRSTV-Z]\d$/i,CH:Be,CZ:/^\d{3}\s?\d{2}$/,DE:De,DK:Be,DZ:De,EE:De,ES:De,FI:De,FR:/^\d{2}\s?\d{3}$/,GB:/^(gir\s?0aa|[a-z]{1,2}\d[\da-z]?\s?(\d[a-z]{2})?)$/i,GR:/^\d{3}\s?\d{2}$/,HR:/^([1-5]\d{4}$)/,HU:Be,IL:De,IN:ye,IS:/^\d{3}$/,IT:De,JP:/^\d{3}\-\d{4}$/,KE:De,LI:/^(948[5-9]|949[0-7])$/,LT:/^LT\-\d{5}$/,LU:Be,LV:/^LV\-\d{4}$/,MX:De,NL:/^\d{4}\s?[a-z]{2}$/i,NO:Be,PL:/^\d{2}\-\d{3}$/,PT:/^\d{4}\-\d{3}?$/,RO:ye,RU:ye,SA:De,SE:/^\d{3}\s?\d{2}$/,SI:Be,SK:/^\d{3}\s?\d{2}$/,TN:Be,TW:/^\d{3}(\d{2})?$/,US:/^\d{5}(-\d{4})?$/,ZA:Be,ZM:De},Oe=Object.keys(Ge);function be(e,t){g(e);var r=t?new RegExp("^["+t+"]+","g"):/^\s+/g;return e.replace(r,"")}function Pe(e,t){g(e);for(var r=t?new RegExp("["+t+"]"):/\s/,i=e.length-1;0<=i&&r.test(e[i]);i--);return i<e.length?e.substr(0,i+1):e}function Ue(e,t){return g(e),e.replace(new RegExp("["+t+"]+","g"),"")}var ke={all_lowercase:!0,gmail_lowercase:!0,gmail_remove_dots:!0,gmail_remove_subaddress:!0,gmail_convert_googlemaildotcom:!0,outlookdotcom_lowercase:!0,outlookdotcom_remove_subaddress:!0,yahoo_lowercase:!0,yahoo_remove_subaddress:!0,yandex_lowercase:!0,icloud_lowercase:!0,icloud_remove_subaddress:!0},Ke=["icloud.com","me.com"],He=["hotmail.at","hotmail.be","hotmail.ca","hotmail.cl","hotmail.co.il","hotmail.co.nz","hotmail.co.th","hotmail.co.uk","hotmail.com","hotmail.com.ar","hotmail.com.au","hotmail.com.br","hotmail.com.gr","hotmail.com.mx","hotmail.com.pe","hotmail.com.tr","hotmail.com.vn","hotmail.cz","hotmail.de","hotmail.dk","hotmail.es","hotmail.fr","hotmail.hu","hotmail.id","hotmail.ie","hotmail.in","hotmail.it","hotmail.jp","hotmail.kr","hotmail.lv","hotmail.my","hotmail.ph","hotmail.pt","hotmail.sa","hotmail.sg","hotmail.sk","live.be","live.co.uk","live.com","live.com.ar","live.com.mx","live.de","live.es","live.eu","live.fr","live.it","live.nl","msn.com","outlook.at","outlook.be","outlook.cl","outlook.co.il","outlook.co.nz","outlook.co.th","outlook.com","outlook.com.ar","outlook.com.au","outlook.com.br","outlook.com.gr","outlook.com.pe","outlook.com.tr","outlook.com.vn","outlook.cz","outlook.de","outlook.dk","outlook.es","outlook.fr","outlook.hu","outlook.id","outlook.ie","outlook.in","outlook.it","outlook.jp","outlook.kr","outlook.lv","outlook.my","outlook.ph","outlook.pt","outlook.sa","outlook.sg","outlook.sk","passport.com"],ze=["rocketmail.com","yahoo.ca","yahoo.co.uk","yahoo.com","yahoo.de","yahoo.fr","yahoo.in","yahoo.it","ymail.com"],We=["yandex.ru","yandex.ua","yandex.kz","yandex.com","yandex.by","ya.ru"];function Ve(e){return 1<e.length?e:""}return{version:"10.7.1",toDate:o,toFloat:r,toInt:function(e,t){return g(e),parseInt(e,t||10)},toBoolean:function(e,t){return g(e),t?"1"===e||"true"===e:"0"!==e&&"false"!==e&&""!==e},equals:function(e,t){return g(e),e===t},contains:function(e,t){return g(e),0<=e.indexOf(n(t))},matches:function(e,t,r){return g(e),"[object RegExp]"!==Object.prototype.toString.call(t)&&(t=new RegExp(t,r)),t.test(e)},isEmail:function(e,t){if(g(e),(t=A(t,$)).require_display_name||t.allow_display_name){var r=e.match(_);if(r)e=r[1];else if(t.require_display_name)return!1}var i=e.split("@"),o=i.pop(),n=i.join("@"),a=o.toLowerCase();if(t.domain_specific_validation&&("gmail.com"===a||"googlemail.com"===a)){var l=(n=n.toLowerCase()).split("+")[0];if(!h(l.replace(".",""),{min:6,max:30}))return!1;for(var s=l.split("."),u=0;u<s.length;u++)if(!S.test(s[u]))return!1}if(!h(n,{max:64})||!h(o,{max:254}))return!1;if(!v(o,{require_tld:t.require_tld})){if(!t.allow_ip_domain)return!1;if(!m(o)){if(!o.startsWith("[")||!o.endsWith("]"))return!1;var d=o.substr(1,o.length-2);if(0===d.length||!m(d))return!1}}if('"'===n[0])return n=n.slice(1,n.length-1),t.allow_utf8_local_part?x.test(n):R.test(n);for(var c=t.allow_utf8_local_part?E:F,f=n.split("."),p=0;p<f.length;p++)if(!c.test(f[p]))return!1;return!0},isURL:function(e,t){if(g(e),!e||2083<=e.length||/[\s<>]/.test(e))return!1;if(0===e.indexOf("mailto:"))return!1;t=A(t,c);var r=void 0,i=void 0,o=void 0,n=void 0,a=void 0,l=void 0,s=void 0,u=void 0;if(1<(s=(e=(s=(e=(s=e.split("#")).shift()).split("?")).shift()).split("://")).length){if(r=s.shift().toLowerCase(),t.require_valid_protocol&&-1===t.protocols.indexOf(r))return!1}else{if(t.require_protocol)return!1;if("//"===e.substr(0,2)){if(!t.allow_protocol_relative_urls)return!1;s[0]=e.substr(2)}}if(""===(e=s.join("://")))return!1;if(""===(e=(s=e.split("/")).shift())&&!t.require_host)return!0;if(1<(s=e.split("@")).length&&0<=(i=s.shift()).indexOf(":")&&2<i.split(":").length)return!1;u=l=null;var d=(n=s.join("@")).match(f);return d?(o="",u=d[1],l=d[2]||null):(o=(s=n.split(":")).shift(),s.length&&(l=s.join(":"))),!(null!==l&&(a=parseInt(l,10),!/^[0-9]+$/.test(l)||a<=0||65535<a)||!(m(o)||v(o,t)||u&&m(u,6))||(o=o||u,t.host_whitelist&&!p(o,t.host_whitelist)||t.host_blacklist&&p(o,t.host_blacklist)))},isMACAddress:function(e,t){return g(e),t&&t.no_colons?d.test(e):i.test(e)},isIP:m,isIPRange:function(e){g(e);var t=e.split("/");return 2===t.length&&!!M.test(t[1])&&!(1<t[1].length&&t[1].startsWith("0"))&&m(t[0],4)&&t[1]<=32&&0<=t[1]},isFQDN:v,isBoolean:function(e){return g(e),0<=["true","false","1","0"].indexOf(e)},isAlpha:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"en-US";if(g(e),t in C)return C[t].test(e);throw new Error("Invalid locale '"+t+"'")},isAlphanumeric:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"en-US";if(g(e),t in N)return N[t].test(e);throw new Error("Invalid locale '"+t+"'")},isNumeric:function(e,t){return g(e),t&&t.no_symbols?b.test(e):O.test(e)},isPort:function(e){return k(e,{min:0,max:65535})},isLowercase:function(e){return g(e),e===e.toLowerCase()},isUppercase:function(e){return g(e),e===e.toUpperCase()},isAscii:function(e){return g(e),K.test(e)},isFullWidth:function(e){return g(e),H.test(e)},isHalfWidth:function(e){return g(e),z.test(e)},isVariableWidth:function(e){return g(e),H.test(e)&&z.test(e)},isMultibyte:function(e){return g(e),W.test(e)},isSurrogatePair:function(e){return g(e),V.test(e)},isInt:k,isFloat:function(e,t){g(e),t=t||{};var r=new RegExp("^(?:[-+])?(?:[0-9]+)?(?:\\"+(t.locale?w[t.locale]:".")+"[0-9]*)?(?:[eE][\\+\\-]?(?:[0-9]+))?$");if(""===e||"."===e||"-"===e||"+"===e)return!1;var i=parseFloat(e.replace(",","."));return r.test(e)&&(!t.hasOwnProperty("min")||i>=t.min)&&(!t.hasOwnProperty("max")||i<=t.max)&&(!t.hasOwnProperty("lt")||i<t.lt)&&(!t.hasOwnProperty("gt")||i>t.gt)},isDecimal:function(e,t){if(g(e),(t=A(t,j)).locale in w)return!Y(J,e.replace(/ /g,""))&&(r=t,new RegExp("^[-+]?([0-9]+)?(\\"+w[r.locale]+"[0-9]{"+r.decimal_digits+"})"+(r.force_decimal?"":"?")+"$")).test(e);var r;throw new Error("Invalid locale '"+t.locale+"'")},isHexadecimal:Q,isDivisibleBy:function(e,t){return g(e),r(e)%parseInt(t,10)==0},isHexColor:function(e){return g(e),X.test(e)},isISRC:function(e){return g(e),ee.test(e)},isMD5:function(e){return g(e),te.test(e)},isHash:function(e,t){return g(e),new RegExp("^[a-f0-9]{"+re[t]+"}$").test(e)},isJWT:function(e){return g(e),ie.test(e)},isJSON:function(e){g(e);try{var t=JSON.parse(e);return!!t&&"object"===(void 0===t?"undefined":a(t))}catch(e){}return!1},isEmpty:function(e,t){return g(e),0===((t=A(t,oe)).ignore_whitespace?e.trim().length:e.length)},isLength:function(e,t){g(e);var r=void 0,i=void 0;i="object"===(void 0===t?"undefined":a(t))?(r=t.min||0,t.max):(r=t,arguments[2]);var o=e.match(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g)||[],n=e.length-o.length;return r<=n&&(void 0===i||n<=i)},isByteLength:h,isUUID:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"all";g(e);var r=ne[t];return r&&r.test(e)},isMongoId:function(e){return g(e),Q(e)&&24===e.length},isAfter:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:String(new Date);g(e);var r=o(t),i=o(e);return!!(i&&r&&r<i)},isBefore:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:String(new Date);g(e);var r=o(t),i=o(e);return!!(i&&r&&i<r)},isIn:function(e,t){g(e);var r=void 0;if("[object Array]"!==Object.prototype.toString.call(t))return"object"===(void 0===t?"undefined":a(t))?t.hasOwnProperty(e):!(!t||"function"!=typeof t.indexOf)&&0<=t.indexOf(e);var i=[];for(r in t)({}).hasOwnProperty.call(t,r)&&(i[r]=n(t[r]));return 0<=i.indexOf(e)},isCreditCard:function(e){g(e);var t=e.replace(/[- ]+/g,"");if(!ae.test(t))return!1;for(var r=0,i=void 0,o=void 0,n=void 0,a=t.length-1;0<=a;a--)i=t.substring(a,a+1),o=parseInt(i,10),r+=n&&10<=(o*=2)?o%10+1:o,n=!n;return!(r%10!=0||!t)},isISIN:function(e){if(g(e),!le.test(e))return!1;for(var t=e.replace(/[A-Z]/g,function(e){return parseInt(e,36)}),r=0,i=void 0,o=void 0,n=!0,a=t.length-2;0<=a;a--)i=t.substring(a,a+1),o=parseInt(i,10),r+=n&&10<=(o*=2)?o+1:o,n=!n;return parseInt(e.substr(e.length-1),10)===(1e4-r)%10},isISBN:function e(t){var r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"";if(g(t),!(r=String(r)))return e(t,10)||e(t,13);var i=t.replace(/[\s-]+/g,""),o=0,n=void 0;if("10"===r){if(!se.test(i))return!1;for(n=0;n<9;n++)o+=(n+1)*i.charAt(n);if("X"===i.charAt(9)?o+=100:o+=10*i.charAt(9),o%11==0)return!!i}else if("13"===r){if(!ue.test(i))return!1;for(n=0;n<12;n++)o+=de[n%2]*i.charAt(n);if(i.charAt(12)-(10-o%10)%10==0)return!!i}return!1},isISSN:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};g(e);var r="^\\d{4}-?\\d{3}[\\dX]$";if(r=t.require_hyphen?r.replace("?",""):r,!(r=t.case_sensitive?new RegExp(r):new RegExp(r,"i")).test(e))return!1;for(var i=e.replace("-","").toUpperCase(),o=0,n=0;n<i.length;n++){var a=i[n];o+=("X"===a?10:+a)*(8-n)}return o%11==0},isMobilePhone:function(t,e,r){if(g(t),r&&r.strictMode&&!t.startsWith("+"))return!1;if(Array.isArray(e))return e.some(function(e){return!(!ce.hasOwnProperty(e)||!ce[e].test(t))});if(e in ce)return ce[e].test(t);if(e&&"any"!==e)throw new Error("Invalid locale '"+e+"'");for(var i in ce)if(ce.hasOwnProperty(i)&&ce[i].test(t))return!0;return!1},isPostalCode:function(e,t){if(g(e),t in Ge)return Ge[t].test(e);if("any"!==t)throw new Error("Invalid locale '"+t+"'");for(var r in Ge)if(Ge.hasOwnProperty(r)&&Ge[r].test(e))return!0;return!1},isPostalCodeLocales:Oe,isCurrency:function(e,t){return g(e),function(e){var r="\\d{"+e.digits_after_decimal[0]+"}";e.digits_after_decimal.forEach(function(e,t){0!==t&&(r=r+"|\\d{"+e+"}")});var t="(\\"+e.symbol.replace(/\./g,"\\.")+")"+(e.require_symbol?"":"?"),i="("+["0","[1-9]\\d*","[1-9]\\d{0,2}(\\"+e.thousands_separator+"\\d{3})*"].join("|")+")?",o="(\\"+e.decimal_separator+"("+r+"))"+(e.require_decimal?"":"?"),n=i+(e.allow_decimal||e.require_decimal?o:"");return e.allow_negatives&&!e.parens_for_negatives&&(e.negative_sign_after_digits?n+="-?":e.negative_sign_before_digits&&(n="-?"+n)),e.allow_negative_sign_placeholder?n="( (?!\\-))?"+n:e.allow_space_after_symbol?n=" ?"+n:e.allow_space_after_digits&&(n+="( (?!$))?"),e.symbol_after_digits?n+=t:n=t+n,e.allow_negatives&&(e.parens_for_negatives?n="(\\("+n+"\\)|"+n+")":e.negative_sign_before_digits||e.negative_sign_after_digits||(n="-?"+n)),new RegExp("^(?!-? )(?=.*\\d)"+n+"$")}(t=A(t,fe)).test(e)},isISO8601:function(e){return g(e),pe.test(e)},isRFC3339:function(e){return g(e),Fe.test(e)},isISO31661Alpha2:function(e){return g(e),Y(Se,e.toUpperCase())},isISO31661Alpha3:function(e){return g(e),Y(Re,e.toUpperCase())},isBase64:function(e){g(e);var t=e.length;if(!t||t%4!=0||Ee.test(e))return!1;var r=e.indexOf("=");return-1===r||r===t-1||r===t-2&&"="===e[t-1]},isDataURI:function(e){g(e);var t=e.split(",");if(t.length<2)return!1;var r=t.shift().trim().split(";"),i=r.shift();if("data:"!==i.substr(0,5))return!1;var o=i.substr(5);if(""!==o&&!xe.test(o))return!1;for(var n=0;n<r.length;n++)if(n===r.length-1&&"base64"===r[n].toLowerCase());else if(!Me.test(r[n]))return!1;for(var a=0;a<t.length;a++)if(!Ce.test(t[a]))return!1;return!0},isMagnetURI:function(e){return g(e),Ne.test(e.trim())},isMimeType:function(e){return g(e),we.test(e)||Le.test(e)||Ie.test(e)},isLatLong:function(e){if(g(e),!e.includes(","))return!1;var t=e.split(",");return Te.test(t[0])&&Ze.test(t[1])},ltrim:be,rtrim:Pe,trim:function(e,t){return Pe(be(e,t),t)},escape:function(e){return g(e),e.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\//g,"&#x2F;").replace(/\\/g,"&#x5C;").replace(/`/g,"&#96;")},unescape:function(e){return g(e),e.replace(/&amp;/g,"&").replace(/&quot;/g,'"').replace(/&#x27;/g,"'").replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&#x2F;/g,"/").replace(/&#x5C;/g,"\\").replace(/&#96;/g,"`")},stripLow:function(e,t){return g(e),Ue(e,t?"\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F":"\\x00-\\x1F\\x7F")},whitelist:function(e,t){return g(e),e.replace(new RegExp("[^"+t+"]+","g"),"")},blacklist:Ue,isWhitelisted:function(e,t){g(e);for(var r=e.length-1;0<=r;r--)if(-1===t.indexOf(e[r]))return!1;return!0},normalizeEmail:function(e,t){t=A(t,ke);var r=e.split("@"),i=r.pop(),o=[r.join("@"),i];if(o[1]=o[1].toLowerCase(),"gmail.com"===o[1]||"googlemail.com"===o[1]){if(t.gmail_remove_subaddress&&(o[0]=o[0].split("+")[0]),t.gmail_remove_dots&&(o[0]=o[0].replace(/\.+/g,Ve)),!o[0].length)return!1;(t.all_lowercase||t.gmail_lowercase)&&(o[0]=o[0].toLowerCase()),o[1]=t.gmail_convert_googlemaildotcom?"gmail.com":o[1]}else if(0<=Ke.indexOf(o[1])){if(t.icloud_remove_subaddress&&(o[0]=o[0].split("+")[0]),!o[0].length)return!1;(t.all_lowercase||t.icloud_lowercase)&&(o[0]=o[0].toLowerCase())}else if(0<=He.indexOf(o[1])){if(t.outlookdotcom_remove_subaddress&&(o[0]=o[0].split("+")[0]),!o[0].length)return!1;(t.all_lowercase||t.outlookdotcom_lowercase)&&(o[0]=o[0].toLowerCase())}else if(0<=ze.indexOf(o[1])){if(t.yahoo_remove_subaddress){var n=o[0].split("-");o[0]=1<n.length?n.slice(0,-1).join("-"):n[0]}if(!o[0].length)return!1;(t.all_lowercase||t.yahoo_lowercase)&&(o[0]=o[0].toLowerCase())}else 0<=We.indexOf(o[1])?((t.all_lowercase||t.yandex_lowercase)&&(o[0]=o[0].toLowerCase()),o[1]="yandex.ru"):t.all_lowercase&&(o[0]=o[0].toLowerCase());return o.join("@")},toString:n}});