import _extends from "@babel/runtime/helpers/esm/extends";
import _mergeJSXProps from "@vue/babel-helper-vue-jsx-merge-props";
import { createNamespace } from '../utils';
import { WHITE } from '../utils/constant';
import { inherit } from '../utils/functional';
import { PopupMixin } from '../mixins/popup';
import Popup from '../popup'; // Types

var _createNamespace = createNamespace('notify'),
    createComponent = _createNamespace[0],
    bem = _createNamespace[1];

function Notify(h, props, slots, ctx) {
  var style = {
    color: props.color,
    background: props.background
  };
  return h(Popup, _mergeJSXProps([{
    "attrs": {
      "value": props.value,
      "position": "top",
      "overlay": false,
      "lockScroll": false
    },
    "style": style,
    "class": [bem([props.type]), props.className]
  }, inherit(ctx, true)]), [props.message]);
}

Notify.props = _extends({}, PopupMixin.props, {
  background: String,
  className: null,
  message: [Number, String],
  getContainer: [String, Function],
  type: {
    type: String,
    default: 'danger'
  },
  color: {
    type: String,
    default: WHITE
  },
  duration: {
    type: Number,
    default: 3000
  }
});
export default createComponent(Notify);