import _mergeJSXProps from "@vue/babel-helper-vue-jsx-merge-props";
import { createNamespace, addUnit } from '../utils';
import { emit, inherit } from '../utils/functional';
import { preventDefault } from '../utils/dom/event';
import Icon from '../icon'; // Types

var _createNamespace = createNamespace('rate'),
    createComponent = _createNamespace[0],
    bem = _createNamespace[1];

function getRateStatus(value, index, allowHalf) {
  if (value >= index) {
    return 'full';
  }

  if (value + 0.5 >= index && allowHalf) {
    return 'half';
  }

  return 'void';
}

function Rate(h, props, slots, ctx) {
  var icon = props.icon,
      color = props.color,
      count = props.count,
      voidIcon = props.voidIcon,
      readonly = props.readonly,
      disabled = props.disabled,
      voidColor = props.voidColor,
      disabledColor = props.disabledColor;
  var list = [];

  for (var i = 1; i <= count; i++) {
    list.push(getRateStatus(props.value, i, props.allowHalf));
  }

  function onSelect(index) {
    if (!disabled && !readonly) {
      emit(ctx, 'input', index);
      emit(ctx, 'change', index);
    }
  }

  function onTouchMove(event) {
    if (readonly || disabled || !document.elementFromPoint) {
      return;
    }

    preventDefault(event);
    var _event$touches$ = event.touches[0],
        clientX = _event$touches$.clientX,
        clientY = _event$touches$.clientY;
    var target = document.elementFromPoint(clientX, clientY);

    if (target && target.dataset) {
      var score = target.dataset.score;
      /* istanbul ignore else */

      if (score) {
        onSelect(+score);
      }
    }
  }

  var gutter = addUnit(props.gutter);

  function renderStar(status, index) {
    var isFull = status === 'full';
    var isVoid = status === 'void';
    var score = index + 1;
    var size = addUnit(props.size);
    var style;

    if (gutter && score !== count) {
      style = {
        paddingRight: gutter
      };
    }

    return h("div", {
      "key": index,
      "attrs": {
        "role": "radio",
        "tabindex": "0",
        "aria-setsize": count,
        "aria-posinset": score,
        "aria-checked": String(!isVoid)
      },
      "style": style,
      "class": bem('item')
    }, [h(Icon, {
      "attrs": {
        "size": size,
        "name": isFull ? icon : voidIcon,
        "data-score": score,
        "color": disabled ? disabledColor : isFull ? color : voidColor
      },
      "class": bem('icon'),
      "on": {
        "click": function click() {
          onSelect(score);
        }
      }
    }), props.allowHalf && h(Icon, {
      "attrs": {
        "size": size,
        "name": isVoid ? voidIcon : icon,
        "data-score": score - 0.5,
        "color": disabled ? disabledColor : isVoid ? voidColor : color
      },
      "class": bem('icon', 'half'),
      "on": {
        "click": function click() {
          onSelect(score - 0.5);
        }
      }
    })]);
  }

  return h("div", _mergeJSXProps([{
    "class": bem(),
    "attrs": {
      "tabindex": "0",
      "role": "radiogroup"
    }
  }, inherit(ctx), {
    "on": {
      "touchmove": onTouchMove
    }
  }]), [list.map(function (status, index) {
    return renderStar(status, index);
  })]);
}

Rate.props = {
  size: [Number, String],
  gutter: [Number, String],
  readonly: Boolean,
  disabled: Boolean,
  allowHalf: Boolean,
  value: {
    type: Number,
    default: 0
  },
  icon: {
    type: String,
    default: 'star'
  },
  voidIcon: {
    type: String,
    default: 'star-o'
  },
  color: {
    type: String,
    default: '#ffd21e'
  },
  voidColor: {
    type: String,
    default: '#c7c7c7'
  },
  disabledColor: {
    type: String,
    default: '#bdbdbd'
  },
  count: {
    type: Number,
    default: 5
  }
};
export default createComponent(Rate);