import { createVNode as _createVNode } from "vue";
import { isDef, createNamespace } from '../utils';
import Cell from '../cell';

var _createNamespace = createNamespace('coupon-cell'),
    createComponent = _createNamespace[0],
    bem = _createNamespace[1],
    t = _createNamespace[2];

function formatValue(props) {
  var coupons = props.coupons,
      chosenCoupon = props.chosenCoupon,
      currency = props.currency;
  var coupon = coupons[+chosenCoupon];

  if (coupon) {
    var value = 0;

    if (isDef(coupon.value)) {
      value = coupon.value;
    } else if (isDef(coupon.denominations)) {
      value = coupon.denominations;
    }

    return "-" + currency + " " + (value / 100).toFixed(2);
  }

  return coupons.length === 0 ? t('tips') : t('count', coupons.length);
}

export default createComponent({
  props: {
    title: String,
    coupons: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    currency: {
      type: String,
      default: '¥'
    },
    border: {
      type: Boolean,
      default: true
    },
    editable: {
      type: Boolean,
      default: true
    },
    chosenCoupon: {
      type: [Number, String],
      default: -1
    }
  },
  setup: function setup(props) {
    return function () {
      var selected = props.coupons[+props.chosenCoupon];
      var value = formatValue(props);
      return _createVNode(Cell, {
        "class": bem(),
        "value": value,
        "title": props.title || t('title'),
        "border": props.border,
        "isLink": props.editable,
        "valueClass": bem('value', {
          selected: selected
        })
      }, null);
    };
  }
});