/**
 * Create a basic component with common options
 */
import { defineComponent } from 'vue';
import { camelize } from '../format/string';
export function createComponent(name) {
  return function (sfc) {
    sfc.name = name;

    sfc.install = function (app) {
      app.component(name, sfc);
      app.component(camelize("-" + name), sfc);
    };

    return defineComponent(sfc);
  };
}