"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = void 0;

var _vue = require("vue");

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _utils = require("../utils");

var _use = require("@vant/use");

var _useExpose = require("../composables/use-expose");

var _useLazyRender = require("../composables/use-lazy-render");

var _cell = _interopRequireWildcard(require("../cell"));

var _collapse = require("../collapse");

// Utils
// Composition
// Components
var _createNamespace = (0, _utils.createNamespace)('collapse-item'),
    createComponent = _createNamespace[0],
    bem = _createNamespace[1];

var _default = createComponent({
  props: (0, _extends2.default)({}, _cell.cellProps, {
    name: [Number, String],
    disabled: Boolean,
    isLink: {
      type: Boolean,
      default: true
    }
  }),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var wrapperRef = (0, _vue.ref)();
    var contentRef = (0, _vue.ref)();

    var _useParent = (0, _use.useParent)(_collapse.COLLAPSE_KEY),
        parent = _useParent.parent,
        index = _useParent.index;

    var currentName = (0, _vue.computed)(function () {
      var _props$name;

      return (_props$name = props.name) != null ? _props$name : index.value;
    });
    var expanded = (0, _vue.computed)(function () {
      if (parent) {
        return parent.isExpanded(currentName.value);
      }

      return null;
    });
    var show = (0, _vue.ref)(expanded.value);
    var lazyRender = (0, _useLazyRender.useLazyRender)(show);

    var onTransitionEnd = function onTransitionEnd() {
      if (!expanded.value) {
        show.value = false;
      } else {
        wrapperRef.value.style.height = '';
      }
    };

    (0, _vue.watch)(expanded, function (value, oldValue) {
      if (oldValue === null) {
        return;
      }

      if (value) {
        show.value = true;
      } // Use raf: flick when opened in safari
      // Use nextTick: closing animation failed when set `user-select: none`


      var tick = value ? _vue.nextTick : _use.raf;
      tick(function () {
        if (!contentRef.value || !wrapperRef.value) {
          return;
        }

        var offsetHeight = contentRef.value.offsetHeight;

        if (offsetHeight) {
          var contentHeight = offsetHeight + "px";
          wrapperRef.value.style.height = value ? 0 : contentHeight; // use double raf to ensure animation can start

          (0, _use.doubleRaf)(function () {
            wrapperRef.value.style.height = value ? contentHeight : 0;
          });
        } else {
          onTransitionEnd();
        }
      });
    });

    var toggle = function toggle(value) {
      if (value === void 0) {
        value = !expanded.value;
      }

      parent.toggle(currentName.value, value);
    };

    var onClickTitle = function onClickTitle() {
      if (!props.disabled) {
        toggle();
      }
    };

    var renderTitle = function renderTitle() {
      var border = props.border,
          disabled = props.disabled;
      return (0, _vue.createVNode)(_cell.default, (0, _vue.mergeProps)({
        "role": "button",
        "class": bem('title', {
          disabled: disabled,
          expanded: expanded.value,
          borderless: !border
        }),
        "tabindex": disabled ? -1 : 0,
        "aria-expanded": String(expanded.value),
        "onClick": onClickTitle
      }, props), {
        icon: slots.icon,
        title: slots.title,
        default: slots.value,
        'right-icon': slots['right-icon']
      });
    };

    var renderContent = lazyRender(function () {
      return (0, _vue.withDirectives)((0, _vue.createVNode)("div", {
        "ref": wrapperRef,
        "class": bem('wrapper'),
        "onTransitionend": onTransitionEnd
      }, [(0, _vue.createVNode)("div", {
        "ref": contentRef,
        "class": bem('content')
      }, [slots.default == null ? void 0 : slots.default()])]), [[_vue.vShow, show.value]]);
    });
    (0, _useExpose.useExpose)({
      toggle: toggle
    });
    return function () {
      return (0, _vue.createVNode)("div", {
        "class": [bem({
          border: index.value && props.border
        })]
      }, [renderTitle(), renderContent()]);
    };
  }
});

exports.default = _default;