"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = void 0;

var _vue = require("vue");

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _utils = require("../utils");

var _useExpose = require("../composables/use-expose");

var _TimePicker = _interopRequireDefault(require("./TimePicker"));

var _DatePicker = _interopRequireDefault(require("./DatePicker"));

var _createNamespace = (0, _utils.createNamespace)('datetime-picker'),
    createComponent = _createNamespace[0],
    bem = _createNamespace[1];

var timePickerProps = Object.keys(_TimePicker.default.props);
var datePickerProps = Object.keys(_DatePicker.default.props);

var _default = createComponent({
  props: (0, _extends2.default)({}, _TimePicker.default.props, _DatePicker.default.props),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
        slots = _ref.slots;
    var root = (0, _vue.ref)();
    (0, _useExpose.useExpose)({
      getPicker: function getPicker() {
        var _root$value;

        return (_root$value = root.value) == null ? void 0 : _root$value.getPicker();
      }
    });
    return function () {
      var isTimePicker = props.type === 'time';
      var Component = isTimePicker ? _TimePicker.default : _DatePicker.default;
      var inheritProps = (0, _utils.pick)(props, isTimePicker ? timePickerProps : datePickerProps);
      return (0, _vue.createVNode)(Component, (0, _vue.mergeProps)({
        "ref": root,
        "class": bem()
      }, (0, _extends2.default)({}, inheritProps, attrs)), (0, _extends2.default)({}, slots));
    };
  }
});

exports.default = _default;