"use strict";

exports.__esModule = true;
exports.scrollLeftTo = scrollLeftTo;
exports.scrollTopTo = scrollTopTo;

var _use = require("@vant/use");

var _utils = require("../utils");

var rafId;

function scrollLeftTo(scroller, to, duration) {
  (0, _use.cancelRaf)(rafId);
  var count = 0;
  var from = scroller.scrollLeft;
  var frames = duration === 0 ? 1 : Math.round(duration * 1000 / 16);

  function animate() {
    scroller.scrollLeft += (to - from) / frames;

    if (++count < frames) {
      rafId = (0, _use.raf)(animate);
    }
  }

  animate();
}

function scrollTopTo(scroller, to, duration, callback) {
  var current = (0, _utils.getScrollTop)(scroller);
  var isDown = current < to;
  var frames = duration === 0 ? 1 : Math.round(duration * 1000 / 16);
  var step = (to - current) / frames;

  function animate() {
    current += step;

    if (isDown && current > to || !isDown && current < to) {
      current = to;
    }

    (0, _utils.setScrollTop)(scroller, current);

    if (isDown && current < to || !isDown && current > to) {
      (0, _use.raf)(animate);
    } else if (callback) {
      (0, _use.raf)(callback);
    }
  }

  animate();
}