import { createVNode as _createVNode } from "vue";
import { defineComponent } from "vue";
import { extend, createNamespace, makeRequiredProp } from "../utils";
import { Tag } from "../tag";
import { Icon } from "../icon";
import { Cell } from "../cell";
import { Radio } from "../radio";
const [name, bem] = createNamespace("address-item");
var stdin_default = defineComponent({
  name,
  props: {
    address: makeRequiredProp(Object),
    disabled: Boolean,
    switchable: Boolean,
    defaultTagText: String
  },
  emits: ["edit", "click", "select"],
  setup(props, {
    slots,
    emit
  }) {
    const onClick = () => {
      if (props.switchable) {
        emit("select");
      }
      emit("click");
    };
    const renderRightIcon = () => _createVNode(Icon, {
      "name": "edit",
      "class": bem("edit"),
      "onClick": (event) => {
        event.stopPropagation();
        emit("edit");
        emit("click");
      }
    }, null);
    const renderTag = () => {
      if (slots.tag) {
        return slots.tag(props.address);
      }
      if (props.address.isDefault && props.defaultTagText) {
        return _createVNode(Tag, {
          "type": "danger",
          "round": true,
          "class": bem("tag")
        }, {
          default: () => [props.defaultTagText]
        });
      }
    };
    const renderContent = () => {
      const {
        address,
        disabled,
        switchable
      } = props;
      const Info = [_createVNode("div", {
        "class": bem("name")
      }, [`${address.name} ${address.tel}`, renderTag()]), _createVNode("div", {
        "class": bem("address")
      }, [address.address])];
      if (switchable && !disabled) {
        return _createVNode(Radio, {
          "name": address.id,
          "iconSize": 18
        }, {
          default: () => [Info]
        });
      }
      return Info;
    };
    return () => {
      var _a;
      const {
        disabled
      } = props;
      return _createVNode("div", {
        "class": bem({
          disabled
        }),
        "onClick": onClick
      }, [_createVNode(Cell, {
        "border": false,
        "valueClass": bem("value")
      }, {
        value: renderContent,
        "right-icon": renderRightIcon
      }), (_a = slots.bottom) == null ? void 0 : _a.call(slots, extend({}, props.address, {
        disabled
      }))]);
    };
  }
});
export {
  stdin_default as default
};
