import { useRect } from "@vant/use";
import { ref, onMounted, nextTick } from "vue";
const useHeight = (element) => {
  const height = ref();
  const setHeight = () => {
    height.value = useRect(element).height;
  };
  onMounted(() => {
    nextTick(setHeight);
    setTimeout(setHeight, 100);
  });
  return height;
};
export {
  useHeight
};
