import { ref, watch } from "vue";
function useLazyRender(show) {
  const inited = ref(false);
  watch(show, (value) => {
    if (value) {
      inited.value = value;
    }
  }, { immediate: true });
  return (render) => () => inited.value ? render() : null;
}
export {
  useLazyRender
};
