import { createVNode as _createVNode } from "vue";
import { defineComponent } from "vue";
import { getSizeStyle, makeStringProp, createNamespace } from "../utils";
import { Network } from "./Network";
const [name, bem] = createNamespace("empty");
const PRESET_IMAGES = ["error", "search", "default"];
const emptyProps = {
  image: makeStringProp("default"),
  imageSize: [Number, String, Array],
  description: String
};
var stdin_default = defineComponent({
  name,
  props: emptyProps,
  setup(props, {
    slots
  }) {
    const renderImage = () => {
      if (slots.image) {
        return slots.image();
      }
      let {
        image
      } = props;
      if (image === "network") {
        return Network;
      }
      if (PRESET_IMAGES.includes(image)) {
        image = `https://img.yzcdn.cn/vant/empty-image-${image}.png`;
      }
      return _createVNode("img", {
        "src": image
      }, null);
    };
    const renderDescription = () => {
      const description = slots.description ? slots.description() : props.description;
      if (description) {
        return _createVNode("p", {
          "class": bem("description")
        }, [description]);
      }
    };
    const renderBottom = () => {
      if (slots.default) {
        return _createVNode("div", {
          "class": bem("bottom")
        }, [slots.default()]);
      }
    };
    return () => _createVNode("div", {
      "class": bem()
    }, [_createVNode("div", {
      "class": bem("image"),
      "style": getSizeStyle(props.imageSize)
    }, [renderImage()]), renderDescription(), renderBottom()]);
  }
});
export {
  stdin_default as default
};
