var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("../utils");
var import_utils2 = require("./utils");
const [name] = (0, import_utils.createNamespace)("calendar-header");
var stdin_default = (0, import_vue2.defineComponent)({
  name,
  props: {
    title: String,
    subtitle: String,
    showTitle: Boolean,
    showSubtitle: Boolean,
    firstDayOfWeek: Number
  },
  emits: ["click-subtitle"],
  setup(props, {
    slots,
    emit
  }) {
    const renderTitle = () => {
      if (props.showTitle) {
        const text = props.title || (0, import_utils2.t)("title");
        const title = slots.title ? slots.title() : text;
        return (0, import_vue.createVNode)("div", {
          "class": (0, import_utils2.bem)("header-title")
        }, [title]);
      }
    };
    const onClickSubtitle = (event) => emit("click-subtitle", event);
    const renderSubtitle = () => {
      if (props.showSubtitle) {
        const title = slots.subtitle ? slots.subtitle() : props.subtitle;
        return (0, import_vue.createVNode)("div", {
          "class": (0, import_utils2.bem)("header-subtitle"),
          "onClick": onClickSubtitle
        }, [title]);
      }
    };
    const renderWeekDays = () => {
      const {
        firstDayOfWeek
      } = props;
      const weekdays = (0, import_utils2.t)("weekdays");
      const renderWeekDays2 = [...weekdays.slice(firstDayOfWeek, 7), ...weekdays.slice(0, firstDayOfWeek)];
      return (0, import_vue.createVNode)("div", {
        "class": (0, import_utils2.bem)("weekdays")
      }, [renderWeekDays2.map((text) => (0, import_vue.createVNode)("span", {
        "class": (0, import_utils2.bem)("weekday")
      }, [text]))]);
    };
    return () => (0, import_vue.createVNode)("div", {
      "class": (0, import_utils2.bem)("header")
    }, [renderTitle(), renderSubtitle(), renderWeekDays()]);
  }
});
