var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("../utils");
var import_Network = require("./Network");
const [name, bem] = (0, import_utils.createNamespace)("empty");
const PRESET_IMAGES = ["error", "search", "default"];
const emptyProps = {
  image: (0, import_utils.makeStringProp)("default"),
  imageSize: [Number, String, Array],
  description: String
};
var stdin_default = (0, import_vue2.defineComponent)({
  name,
  props: emptyProps,
  setup(props, {
    slots
  }) {
    const renderImage = () => {
      if (slots.image) {
        return slots.image();
      }
      let {
        image
      } = props;
      if (image === "network") {
        return import_Network.Network;
      }
      if (PRESET_IMAGES.includes(image)) {
        image = `https://img.yzcdn.cn/vant/empty-image-${image}.png`;
      }
      return (0, import_vue.createVNode)("img", {
        "src": image
      }, null);
    };
    const renderDescription = () => {
      const description = slots.description ? slots.description() : props.description;
      if (description) {
        return (0, import_vue.createVNode)("p", {
          "class": bem("description")
        }, [description]);
      }
    };
    const renderBottom = () => {
      if (slots.default) {
        return (0, import_vue.createVNode)("div", {
          "class": bem("bottom")
        }, [slots.default()]);
      }
    };
    return () => (0, import_vue.createVNode)("div", {
      "class": bem()
    }, [(0, import_vue.createVNode)("div", {
      "class": bem("image"),
      "style": (0, import_utils.getSizeStyle)(props.imageSize)
    }, [renderImage()]), renderDescription(), renderBottom()]);
  }
});
