var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("../utils");
var import_use = require("@vant/use");
var import_loading = require("../loading");
const [name, bem] = (0, import_utils.createNamespace)("switch");
const switchProps = {
  size: import_utils.numericProp,
  loading: Boolean,
  disabled: Boolean,
  modelValue: import_utils.unknownProp,
  activeColor: String,
  inactiveColor: String,
  activeValue: {
    type: import_utils.unknownProp,
    default: true
  },
  inactiveValue: {
    type: import_utils.unknownProp,
    default: false
  }
};
var stdin_default = (0, import_vue2.defineComponent)({
  name,
  props: switchProps,
  emits: ["change", "update:modelValue"],
  setup(props, {
    emit
  }) {
    const isChecked = () => props.modelValue === props.activeValue;
    const onClick = () => {
      if (!props.disabled && !props.loading) {
        const newValue = isChecked() ? props.inactiveValue : props.activeValue;
        emit("update:modelValue", newValue);
        emit("change", newValue);
      }
    };
    const renderLoading = () => {
      if (props.loading) {
        const color = isChecked() ? props.activeColor : props.inactiveColor;
        return (0, import_vue.createVNode)(import_loading.Loading, {
          "class": bem("loading"),
          "color": color
        }, null);
      }
    };
    (0, import_use.useCustomFieldValue)(() => props.modelValue);
    return () => {
      const {
        size,
        loading,
        disabled,
        activeColor,
        inactiveColor
      } = props;
      const checked = isChecked();
      const style = {
        fontSize: (0, import_utils.addUnit)(size),
        backgroundColor: checked ? activeColor : inactiveColor
      };
      return (0, import_vue.createVNode)("div", {
        "role": "switch",
        "class": bem({
          on: checked,
          loading,
          disabled
        }),
        "style": style,
        "tabindex": disabled ? void 0 : 0,
        "aria-checked": checked,
        "onClick": onClick
      }, [(0, import_vue.createVNode)("div", {
        "class": bem("node")
      }, [renderLoading()])]);
    };
  }
});
