var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("./utils");
var import_utils2 = require("../utils");
var import_icon = require("../icon");
var import_image = require("../image");
var import_loading = require("../loading");
var stdin_default = (0, import_vue2.defineComponent)({
  props: {
    name: import_utils2.numericProp,
    item: (0, import_utils2.makeRequiredProp)(Object),
    index: Number,
    imageFit: String,
    lazyLoad: Boolean,
    deletable: Boolean,
    previewSize: [Number, String, Array],
    beforeDelete: Function
  },
  emits: ["delete", "preview"],
  setup(props, {
    emit,
    slots
  }) {
    const renderMask = () => {
      const {
        status,
        message
      } = props.item;
      if (status === "uploading" || status === "failed") {
        const MaskIcon = status === "failed" ? (0, import_vue.createVNode)(import_icon.Icon, {
          "name": "close",
          "class": (0, import_utils.bem)("mask-icon")
        }, null) : (0, import_vue.createVNode)(import_loading.Loading, {
          "class": (0, import_utils.bem)("loading")
        }, null);
        const showMessage = (0, import_utils2.isDef)(message) && message !== "";
        return (0, import_vue.createVNode)("div", {
          "class": (0, import_utils.bem)("mask")
        }, [MaskIcon, showMessage && (0, import_vue.createVNode)("div", {
          "class": (0, import_utils.bem)("mask-message")
        }, [message])]);
      }
    };
    const onDelete = (event) => {
      const {
        name,
        item,
        index,
        beforeDelete
      } = props;
      event.stopPropagation();
      (0, import_utils2.callInterceptor)(beforeDelete, {
        args: [item, {
          name,
          index
        }],
        done: () => emit("delete")
      });
    };
    const onPreview = () => emit("preview");
    const renderDeleteIcon = () => {
      if (props.deletable && props.item.status !== "uploading") {
        return (0, import_vue.createVNode)("div", {
          "role": "button",
          "class": (0, import_utils.bem)("preview-delete"),
          "tabindex": 0,
          "aria-label": (0, import_utils.t)("delete"),
          "onClick": onDelete
        }, [(0, import_vue.createVNode)(import_icon.Icon, {
          "name": "cross",
          "class": (0, import_utils.bem)("preview-delete-icon")
        }, null)]);
      }
    };
    const renderCover = () => {
      if (slots["preview-cover"]) {
        const {
          index,
          item
        } = props;
        return (0, import_vue.createVNode)("div", {
          "class": (0, import_utils.bem)("preview-cover")
        }, [slots["preview-cover"]((0, import_utils2.extend)({
          index
        }, item))]);
      }
    };
    const renderPreview = () => {
      const {
        item,
        lazyLoad,
        imageFit,
        previewSize
      } = props;
      if ((0, import_utils.isImageFile)(item)) {
        return (0, import_vue.createVNode)(import_image.Image, {
          "fit": imageFit,
          "src": item.content || item.url,
          "class": (0, import_utils.bem)("preview-image"),
          "width": Array.isArray(previewSize) ? previewSize[0] : previewSize,
          "height": Array.isArray(previewSize) ? previewSize[1] : previewSize,
          "lazyLoad": lazyLoad,
          "onClick": onPreview
        }, {
          default: renderCover
        });
      }
      return (0, import_vue.createVNode)("div", {
        "class": (0, import_utils.bem)("file"),
        "style": (0, import_utils2.getSizeStyle)(props.previewSize)
      }, [(0, import_vue.createVNode)(import_icon.Icon, {
        "class": (0, import_utils.bem)("file-icon"),
        "name": "description"
      }, null), (0, import_vue.createVNode)("div", {
        "class": [(0, import_utils.bem)("file-name"), "van-ellipsis"]
      }, [item.file ? item.file.name : item.url]), renderCover()]);
    };
    return () => (0, import_vue.createVNode)("div", {
      "class": (0, import_utils.bem)("preview")
    }, [renderPreview(), renderMask(), renderDeleteIcon()]);
  }
});
