/* eslint-disable max-classes-per-file */
import { find, remove } from './util';
var defaultOptions = {
  selector: 'img'
};

class LazyContainer {
  constructor({
    el,
    binding,
    vnode,
    lazy
  }) {
    this.el = null;
    this.vnode = vnode;
    this.binding = binding;
    this.options = {};
    this.lazy = lazy;
    this._queue = [];
    this.update({
      el,
      binding
    });
  }

  update({
    el,
    binding
  }) {
    this.el = el;
    this.options = Object.assign({}, defaultOptions, binding.value);
    var imgs = this.getImgs();
    imgs.forEach(el => {
      this.lazy.add(el, Object.assign({}, this.binding, {
        value: {
          src: 'dataset' in el ? el.dataset.src : el.getAttribute('data-src'),
          error: ('dataset' in el ? el.dataset.error : el.getAttribute('data-error')) || this.options.error,
          loading: ('dataset' in el ? el.dataset.loading : el.getAttribute('data-loading')) || this.options.loading
        }
      }), this.vnode);
    });
  }

  getImgs() {
    return Array.from(this.el.querySelectorAll(this.options.selector));
  }

  clear() {
    var imgs = this.getImgs();
    imgs.forEach(el => this.lazy.remove(el));
    this.vnode = null;
    this.binding = null;
    this.lazy = null;
  }

}

export default class LazyContainerManager {
  constructor({
    lazy
  }) {
    this.lazy = lazy;
    this._queue = [];
  }

  bind(el, binding, vnode) {
    var container = new LazyContainer({
      el,
      binding,
      vnode,
      lazy: this.lazy
    });

    this._queue.push(container);
  }

  update(el, binding, vnode) {
    var container = find(this._queue, item => item.el === el);
    if (!container) return;
    container.update({
      el,
      binding,
      vnode
    });
  }

  unbind(el) {
    var container = find(this._queue, item => item.el === el);
    if (!container) return;
    container.clear();
    remove(this._queue, container);
  }

}