"use strict";

exports.__esModule = true;
exports.useClickAway = useClickAway;

var _vue = require("vue");

var _utils = require("../utils");

var _useEventListener = require("../useEventListener");

function useClickAway(target, listener, options = {}) {
  if (!_utils.inBrowser) {
    return;
  }

  var {
    eventName = 'click'
  } = options;

  var onClick = event => {
    var element = (0, _vue.unref)(target);

    if (element && !element.contains(event.target)) {
      listener(event);
    }
  };

  (0, _useEventListener.useEventListener)(eventName, onClick, {
    target: document
  });
}