"use strict";

exports.__esModule = true;
exports.useEventListener = useEventListener;
exports.supportsPassive = void 0;

var _vue = require("vue");

var _onMountedOrActivated = require("../onMountedOrActivated");

var _utils = require("../utils");

// eslint-disable-next-line
var supportsPassive = false;
exports.supportsPassive = supportsPassive;

if (_utils.inBrowser) {
  try {
    var opts = {};
    Object.defineProperty(opts, 'passive', {
      get() {
        exports.supportsPassive = supportsPassive = true;
      }

    });
    window.addEventListener('test-passive', null, opts); // eslint-disable-next-line no-empty
  } catch (e) {}
}

function useEventListener(type, listener, options = {}) {
  if (!_utils.inBrowser) {
    return;
  }

  var {
    target = window,
    passive = false,
    capture = false
  } = options;
  var attached;

  var add = () => {
    var element = (0, _vue.unref)(target);

    if (element && !attached) {
      element.addEventListener(type, listener, supportsPassive ? {
        capture,
        passive
      } : capture);
      attached = true;
    }
  };

  var remove = () => {
    var element = (0, _vue.unref)(target);

    if (element && attached) {
      element.removeEventListener(type, listener, capture);
      attached = false;
    }
  };

  (0, _vue.onUnmounted)(remove);
  (0, _vue.onDeactivated)(remove);
  (0, _onMountedOrActivated.onMountedOrActivated)(add);
}