"use strict";

exports.__esModule = true;
exports.usePageVisibility = usePageVisibility;

var _vue = require("vue");

var _utils = require("../utils");

var _useEventListener = require("../useEventListener");

function usePageVisibility() {
  var visibility = (0, _vue.ref)('visible');

  var setVisibility = () => {
    if (_utils.inBrowser) {
      visibility.value = document.hidden ? 'hidden' : 'visible';
    }
  };

  setVisibility();
  (0, _useEventListener.useEventListener)('visibilitychange', setVisibility);
  return visibility;
}