"use strict";

exports.__esModule = true;
exports.useRect = void 0;

var _vue = require("vue");

function isWindow(val) {
  return val === window;
}

function makeDOMRect(width, height) {
  return {
    top: 0,
    left: 0,
    right: width,
    bottom: height,
    width,
    height
  };
}

var useRect = elementOrRef => {
  var element = (0, _vue.unref)(elementOrRef);

  if (isWindow(element)) {
    var width = element.innerWidth;
    var height = element.innerHeight;
    return makeDOMRect(width, height);
  }

  if (element && element.getBoundingClientRect) {
    return element.getBoundingClientRect();
  }

  return makeDOMRect(0, 0);
};

exports.useRect = useRect;