"use strict";

exports.__esModule = true;
exports.useParent = useParent;

var _vue = require("vue");

function useParent(key) {
  var parent = (0, _vue.inject)(key, null);

  if (parent) {
    var instance = (0, _vue.getCurrentInstance)();
    var {
      link: _link,
      unlink: _unlink,
      internalChildren
    } = parent;

    _link(instance);

    (0, _vue.onUnmounted)(() => _unlink(instance));
    var index = (0, _vue.computed)(() => internalChildren.indexOf(instance));
    return {
      parent,
      index
    };
  }

  return {
    parent: null,
    index: (0, _vue.ref)(-1)
  };
}