"use strict";

exports.__esModule = true;
exports.getScrollParent = getScrollParent;
exports.useScrollParent = useScrollParent;

var _vue = require("vue");

var _utils = require("../utils");

var overflowScrollReg = /scroll|auto/i;
var defaultRoot = _utils.inBrowser ? window : undefined;

function isElement(node) {
  var ELEMENT_NODE_TYPE = 1;
  return node.tagName !== 'HTML' && node.tagName !== 'BODY' && node.nodeType === ELEMENT_NODE_TYPE;
} // https://github.com/youzan/vant/issues/3823


function getScrollParent(el, root = defaultRoot) {
  var node = el;

  while (node && node !== root && isElement(node)) {
    var {
      overflowY
    } = window.getComputedStyle(node);

    if (overflowScrollReg.test(overflowY)) {
      return node;
    }

    node = node.parentNode;
  }

  return root;
}

function useScrollParent(el, root = defaultRoot) {
  var scrollParent = (0, _vue.ref)();
  (0, _vue.onMounted)(() => {
    if (el.value) {
      scrollParent.value = getScrollParent(el.value, root);
    }
  });
  return scrollParent;
}