"use strict";

exports.__esModule = true;
exports.useWindowSize = useWindowSize;

var _vue = require("vue");

var _utils = require("../utils");

var _useEventListener = require("../useEventListener");

function useWindowSize() {
  var width = (0, _vue.ref)(_utils.inBrowser ? window.innerWidth : 0);
  var height = (0, _vue.ref)(_utils.inBrowser ? window.innerHeight : 0);

  var onResize = () => {
    width.value = window.innerWidth;
    height.value = window.innerHeight;
  };

  (0, _useEventListener.useEventListener)('resize', onResize);
  (0, _useEventListener.useEventListener)('orientationchange', onResize);
  return {
    width,
    height
  };
}