"use strict";

exports.__esModule = true;
exports.raf = raf;
exports.cancelRaf = cancelRaf;
exports.doubleRaf = doubleRaf;
exports.inBrowser = void 0;
var inBrowser = typeof window !== 'undefined';
exports.inBrowser = inBrowser;
var root = inBrowser ? window : global;
var prev = Date.now();

function rafPolyfill(fn) {
  var curr = Date.now();
  var ms = Math.max(0, 16 - (curr - prev));
  var id = setTimeout(fn, ms);
  prev = curr + ms;
  return id;
}

function raf(fn) {
  var requestAnimationFrame = root.requestAnimationFrame || rafPolyfill;
  return requestAnimationFrame.call(root, fn);
}

function cancelRaf(id) {
  var cancelAnimationFrame = root.cancelAnimationFrame || root.clearTimeout;
  cancelAnimationFrame.call(root, id);
} // double raf for animation


function doubleRaf(fn) {
  raf(() => raf(fn));
}