import { unref, onUnmounted, onDeactivated } from 'vue';
import { onMountedOrActivated } from '../onMountedOrActivated';
import { inBrowser } from '../utils'; // eslint-disable-next-line

export var supportsPassive = false;

if (inBrowser) {
  try {
    var opts = {};
    Object.defineProperty(opts, 'passive', {
      get() {
        supportsPassive = true;
      }

    });
    window.addEventListener('test-passive', null, opts); // eslint-disable-next-line no-empty
  } catch (e) {}
}

export function useEventListener(type, listener, options = {}) {
  if (!inBrowser) {
    return;
  }

  var {
    target = window,
    passive = false,
    capture = false
  } = options;
  var attached;

  var add = () => {
    var element = unref(target);

    if (element && !attached) {
      element.addEventListener(type, listener, supportsPassive ? {
        capture,
        passive
      } : capture);
      attached = true;
    }
  };

  var remove = () => {
    var element = unref(target);

    if (element && attached) {
      element.removeEventListener(type, listener, capture);
      attached = false;
    }
  };

  onUnmounted(remove);
  onDeactivated(remove);
  onMountedOrActivated(add);
}