import { ref } from 'vue';
import { inBrowser } from '../utils';
import { useEventListener } from '../useEventListener';
export function usePageVisibility() {
  var visibility = ref('visible');

  var setVisibility = () => {
    if (inBrowser) {
      visibility.value = document.hidden ? 'hidden' : 'visible';
    }
  };

  setVisibility();
  useEventListener('visibilitychange', setVisibility);
  return visibility;
}