import { isVNode, provide, reactive, getCurrentInstance } from 'vue';
export function flattenVNodes(children) {
  var result = [];

  var traverse = children => {
    if (Array.isArray(children)) {
      children.forEach(child => {
        if (isVNode(child)) {
          var _child$component;

          result.push(child);

          if ((_child$component = child.component) != null && _child$component.subTree) {
            traverse(child.component.subTree.children);
          }

          if (child.children) {
            traverse(child.children);
          }
        }
      });
    }
  };

  traverse(children);
  return result;
} // sort children instances by vnodes order

export function sortChildren(parent, publicChildren, internalChildren) {
  var vnodes = flattenVNodes(parent.subTree.children);
  internalChildren.sort((a, b) => vnodes.indexOf(a.vnode) - vnodes.indexOf(b.vnode));
  var orderedPublicChildren = internalChildren.map(item => item.proxy);
  publicChildren.sort((a, b) => {
    var indexA = orderedPublicChildren.indexOf(a);
    var indexB = orderedPublicChildren.indexOf(b);
    return indexA - indexB;
  });
}
export function useChildren(key) {
  var publicChildren = reactive([]);
  var internalChildren = reactive([]);
  var parent = getCurrentInstance();

  var linkChildren = value => {
    var link = child => {
      if (child.proxy) {
        internalChildren.push(child);
        publicChildren.push(child.proxy);
        sortChildren(parent, publicChildren, internalChildren);
      }
    };

    var unlink = child => {
      var index = internalChildren.indexOf(child);
      publicChildren.splice(index, 1);
      internalChildren.splice(index, 1);
    };

    provide(key, Object.assign({
      link,
      unlink,
      children: publicChildren,
      internalChildren
    }, value));
  };

  return {
    children: publicChildren,
    linkChildren
  };
}